/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.p2.internal.deploy.server;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.swordfish.p2.internal.deploy.server.IIUQueryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallableUnits {
    public static final Log LOG = LogFactory.getLog(InstallableUnits.class);
    private static IIUQueryFactory qf = new IIUQueryFactory(){

        @Override
        public IQuery<IInstallableUnit> createIUQuery(String iu) {
            return QueryUtil.createIUQuery((String)iu);
        }
    };
    private IIUQueryFactory myQueryFactory;
    private String[] installableUnits;

    public InstallableUnits(String iusStr) {
        this.installableUnits = InstallableUnits.iuListToArray(iusStr);
        this.myQueryFactory = qf;
    }

    public String[] getUnitNames() {
        return this.installableUnits;
    }

    private static String[] iuListToArray(String iuList) {
        String[] rawList = iuList != null ? iuList.split(",") : new String[]{};
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < rawList.length) {
            if (rawList[i] != null && !"".equals(rawList[i])) {
                result.add(rawList[i].trim());
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }

    public boolean isEmpty() {
        return this.installableUnits.length == 0;
    }

    public Collection<IInstallableUnit> getUnits(IQueryable<IInstallableUnit> queryable, IProgressMonitor monitor) {
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>();
        int i = 0;
        while (i < this.installableUnits.length) {
            IQueryResult units = queryable.query(this.myQueryFactory.createIUQuery(this.installableUnits[i]), monitor);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Query for IU " + this.installableUnits[i]));
            }
            for (IInstallableUnit unit : units) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Added IU " + unit.getId() + " " + unit.getVersion()));
                }
                result.add(unit);
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        StringBuilder idList = new StringBuilder();
        String delim = "";
        int i = 0;
        while (i < this.installableUnits.length) {
            idList.append(delim).append(this.installableUnits[i]);
            delim = ", ";
            ++i;
        }
        return idList.toString();
    }

    public void setQueryFactory(IIUQueryFactory queryFactory) {
        this.myQueryFactory = queryFactory;
    }
}

