/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.xbean;

import java.util.Arrays;
import javax.jbi.management.DeploymentException;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.xbean.AbstractXBeanDeployer;

public class BaseXBeanDeployer
extends AbstractXBeanDeployer {
    private final Class[] endpointClasses;

    public BaseXBeanDeployer(ServiceMixComponent component) {
        this(component, new Class[0]);
    }

    public BaseXBeanDeployer(ServiceMixComponent component, Class endpointClass) {
        this(component, new Class[]{endpointClass});
    }

    public BaseXBeanDeployer(ServiceMixComponent component, Class[] endpointClasses) {
        super(component);
        if (endpointClasses == null) {
            throw new NullPointerException("endpointClasses must be non null");
        }
        this.endpointClasses = endpointClasses;
    }

    protected void validate(Endpoint endpoint) throws DeploymentException {
        for (int i = 0; i < this.endpointClasses.length; ++i) {
            if (!this.endpointClasses[i].isInstance(endpoint)) continue;
            super.validate(endpoint);
            return;
        }
        throw new DeploymentException("Endpoint is not of type: " + Arrays.asList(this.endpointClasses) + " but is of type: " + endpoint.getClass());
    }
}

