/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend.spring;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.configuration.spring.AbstractFactoryBeanDefinitionParser;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

public class ClientProxyFactoryBeanDefinitionParser
extends AbstractFactoryBeanDefinitionParser {
    public ClientProxyFactoryBeanDefinitionParser() {
        this.setBeanClass(Object.class);
    }

    protected Class getFactoryClass() {
        return SpringClientProxyFactoryBean.class;
    }

    protected String getFactoryIdSuffix() {
        return ".proxyFactory";
    }

    protected String getSuffix() {
        return ".simple-client";
    }

    protected void mapAttribute(BeanDefinitionBuilder bean, Element e, String name, String val) {
        if ("endpointName".equals(name) || "serviceName".equals(name)) {
            QName q = this.parseQName(e, val);
            bean.addPropertyValue(name, (Object)q);
        } else {
            this.mapToProperty(bean, name, val);
        }
    }

    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element e, String name) {
        if ("properties".equals(name)) {
            Map map = ctx.getDelegate().parseMapElement(e, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue("properties", (Object)map);
        } else if ("binding".equals(name)) {
            this.setFirstChildAsProperty(e, ctx, bean, "bindingConfig");
        } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name) || "features".equals(name) || "handlers".equals(name)) {
            List list = ctx.getDelegate().parseListElement(e, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else {
            this.setFirstChildAsProperty(e, ctx, bean, name);
        }
    }

    public static class SpringClientProxyFactoryBean
    extends ClientProxyFactoryBean
    implements ApplicationContextAware {
        public SpringClientProxyFactoryBean() {
        }

        public SpringClientProxyFactoryBean(ClientFactoryBean fact) {
            super(fact);
        }

        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            if (this.getBus() == null) {
                Bus bus = BusFactory.getThreadDefaultBus();
                BusWiringBeanFactoryPostProcessor.updateBusReferencesInContext(bus, ctx);
                this.setBus(bus);
            }
        }
    }
}

