/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.bindings.soap.impl;

import java.util.List;
import org.apache.servicemix.soap.api.Interceptor;
import org.apache.servicemix.soap.api.InterceptorProvider;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.bindings.soap.SoapVersion;
import org.apache.servicemix.soap.bindings.soap.interceptors.MustUnderstandInterceptor;
import org.apache.servicemix.soap.bindings.soap.interceptors.SoapActionInOperationInterceptor;
import org.apache.servicemix.soap.bindings.soap.interceptors.SoapActionOutOperationInterceptor;
import org.apache.servicemix.soap.bindings.soap.interceptors.SoapFaultInInterceptor;
import org.apache.servicemix.soap.bindings.soap.interceptors.SoapFaultOutInterceptor;
import org.apache.servicemix.soap.bindings.soap.interceptors.SoapInInterceptor;
import org.apache.servicemix.soap.bindings.soap.interceptors.SoapOutInterceptor;
import org.apache.servicemix.soap.bindings.soap.model.wsdl1.Wsdl1SoapBinding;
import org.apache.servicemix.soap.bindings.soap.model.wsdl1.Wsdl1SoapOperation;
import org.apache.servicemix.soap.core.model.AbstractBinding;
import org.apache.servicemix.soap.interceptors.jbi.JbiFaultOutInterceptor;
import org.apache.servicemix.soap.interceptors.jbi.JbiInInterceptor;
import org.apache.servicemix.soap.interceptors.jbi.JbiInWsdl1Interceptor;
import org.apache.servicemix.soap.interceptors.jbi.JbiOutInterceptor;
import org.apache.servicemix.soap.interceptors.jbi.JbiOutWsdl1Interceptor;
import org.apache.servicemix.soap.interceptors.mime.AttachmentsInInterceptor;
import org.apache.servicemix.soap.interceptors.mime.AttachmentsOutInterceptor;
import org.apache.servicemix.soap.interceptors.wsdl.WsdlOperationInInterceptor;
import org.apache.servicemix.soap.interceptors.xml.BodyOutInterceptor;
import org.apache.servicemix.soap.interceptors.xml.StaxInInterceptor;
import org.apache.servicemix.soap.interceptors.xml.StaxOutInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wsdl1SoapBindingImpl
extends AbstractBinding<Wsdl1SoapOperation>
implements Wsdl1SoapBinding {
    private SoapVersion soapVersion;
    private String locationURI;
    private String transportURI;
    private Wsdl1SoapBinding.Style style;

    public Wsdl1SoapBindingImpl() {
        this(null);
    }

    public Wsdl1SoapBindingImpl(SoapVersion soapVersion) {
        this.soapVersion = soapVersion;
        List<Interceptor> phase = this.getInterceptors(InterceptorProvider.Phase.ServerIn);
        phase.add(new AttachmentsInInterceptor());
        phase.add(new StaxInInterceptor());
        phase.add(new SoapInInterceptor(soapVersion));
        phase.add(new SoapActionInOperationInterceptor());
        phase.add(new WsdlOperationInInterceptor());
        phase.add(new MustUnderstandInterceptor());
        phase.add(new JbiInWsdl1Interceptor(true));
        phase.add(new JbiInInterceptor(true));
        phase = this.getInterceptors(InterceptorProvider.Phase.ServerOut);
        phase.add(new JbiFaultOutInterceptor());
        phase.add(new JbiOutInterceptor(true));
        phase.add(new JbiOutWsdl1Interceptor(true));
        phase.add(new AttachmentsOutInterceptor());
        phase.add(new StaxOutInterceptor());
        phase.add(new SoapOutInterceptor(soapVersion));
        phase.add(new BodyOutInterceptor());
        phase = this.getInterceptors(InterceptorProvider.Phase.ServerOutFault);
        phase.add(new StaxOutInterceptor());
        phase.add(new SoapOutInterceptor(soapVersion));
        phase.add(new SoapFaultOutInterceptor());
        phase = this.getInterceptors(InterceptorProvider.Phase.ClientOut);
        phase.add(new JbiOutInterceptor(false));
        phase.add(new JbiOutWsdl1Interceptor(false));
        phase.add(new SoapActionOutOperationInterceptor());
        phase.add(new AttachmentsOutInterceptor());
        phase.add(new StaxOutInterceptor());
        phase.add(new SoapOutInterceptor(soapVersion));
        phase.add(new BodyOutInterceptor());
        phase = this.getInterceptors(InterceptorProvider.Phase.ClientIn);
        phase.add(new AttachmentsInInterceptor());
        phase.add(new StaxInInterceptor());
        phase.add(new SoapInInterceptor());
        phase.add(new SoapFaultInInterceptor());
        phase.add(new JbiInWsdl1Interceptor(false));
        phase.add(new JbiInInterceptor(false));
    }

    @Override
    public String getLocationURI() {
        return this.locationURI;
    }

    public void setLocationURI(String locationURI) {
        this.locationURI = locationURI;
    }

    @Override
    public String getTransportURI() {
        return this.transportURI;
    }

    public void setTransportURI(String transportURI) {
        this.transportURI = transportURI;
    }

    @Override
    public Wsdl1SoapBinding.Style getStyle() {
        return this.style;
    }

    public void setStyle(Wsdl1SoapBinding.Style style) {
        this.style = style;
    }

    @Override
    public Message createMessage() {
        Message msg = super.createMessage();
        if (msg.get(SoapVersion.class) == null && this.soapVersion != null) {
            msg.put(SoapVersion.class, this.soapVersion);
        }
        return msg;
    }

    @Override
    public Message createMessage(Message request) {
        Message msg = super.createMessage(request);
        if (msg.get(SoapVersion.class) == null && request.get(SoapVersion.class) != null) {
            msg.put(SoapVersion.class, request.get(SoapVersion.class));
        }
        if (msg.get(SoapVersion.class) == null && this.soapVersion != null) {
            msg.put(SoapVersion.class, this.soapVersion);
        }
        return msg;
    }
}

