/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.interceptor;

import java.util.HashMap;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Message;
import org.apache.servicemix.nmr.api.Type;
import org.eclipse.swordfish.core.Interceptor;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.internal.core.util.smx.ServiceMixSupport;
import org.eclipse.swordfish.internal.core.util.xml.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingInterceptor
implements Interceptor {
    private static final Log LOG = LogFactory.getLog(LoggingInterceptor.class);
    private final Map<String, ?> properties = new HashMap();

    public void process(MessageExchange messageExchange, Map<String, Object> contextProps) throws SwordfishException {
        try {
            Exchange exchange = ServiceMixSupport.toNMRExchange((MessageExchange)messageExchange);
            String requestMsg = null;
            Message request = exchange.getMessage(Type.In);
            if (request != null) {
                requestMsg = XmlUtil.toStringFromSource((Source)((Source)request.getBody()));
            }
            String responseMsg = null;
            Message response = exchange.getMessage(Type.Out);
            if (response != null) {
                responseMsg = XmlUtil.toStringFromSource((Source)((Source)response.getBody()));
            }
            LOG.info((Object)String.format("Received messageExchange with request = [%s] and response = [%s]", requestMsg, responseMsg));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Map<String, ?> getProperties() {
        return this.properties;
    }
}

