/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.proxy;

import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Pattern;
import org.apache.servicemix.nmr.api.Status;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.core.proxy.ServiceProxy;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ServiceProxyImpl
implements ServiceProxy,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(ServiceProxyImpl.class);
    private NMR nmr;

    public Source invokeRequestResponseOperation(QName serviceName, QName operationName, Source inMessage) throws SwordfishException {
        Channel channel = null;
        Source response = null;
        try {
            try {
                channel = this.nmr.createChannel();
                Exchange exchange = channel.createExchange(Pattern.InOut);
                exchange.getIn().setBody((Object)inMessage);
                exchange.setOperation(operationName);
                HashMap<String, String> targetProps = new HashMap<String, String>();
                targetProps.put("SERVICE_NAME", serviceName.toString());
                exchange.setTarget(this.nmr.getEndpointRegistry().lookup(targetProps));
                if (exchange.getTarget() == null) {
                    throw new SwordfishException("No target endpoint found for service: " + serviceName.toString());
                }
                channel.sendSync(exchange);
                if (exchange.getError() != null) {
                    throw exchange.getError();
                }
                if (exchange.getFault() != null && exchange.getFault().getBody() != null) {
                    Object fault = exchange.getFault().getBody();
                    throw new SwordfishException(fault.toString());
                }
                response = (Source)exchange.getOut().getBody(Source.class);
                exchange.setStatus(Status.Done);
                channel.send(exchange);
            }
            catch (Exception e) {
                LOG.error((Object)"The invocation wasn't successful:", (Throwable)e);
                throw new SwordfishException("The invocation wasn't successful:", (Throwable)e);
            }
        }
        finally {
            if (channel != null) {
                channel.close();
            }
        }
        return response;
    }

    public NMR getNmr() {
        return this.nmr;
    }

    public void setNmr(NMR nmr) {
        this.nmr = nmr;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.nmr, (String)"NMR must be set.");
    }
}

