/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.spring;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Reference;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.service.importer.support.OsgiServiceProxyFactoryBean;

public class ReferenceFactory
implements FactoryBean,
InitializingBean,
BundleContextAware {
    private BundleContext bundleContext;
    private NMR nmr;
    private String name;
    private QName itf;
    private QName service;
    private String endpoint;
    private Reference reference;

    public NMR getNmr() {
        return this.nmr;
    }

    public void setNmr(NMR nmr) {
        this.nmr = nmr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QName getInterface() {
        return this.itf;
    }

    public void setInterface(QName itf) {
        this.itf = itf;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        this.service = service;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Object getObject() throws Exception {
        if (this.reference == null) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (this.name != null) {
                props.put("NAME", this.name);
            }
            if (this.itf != null) {
                props.put("INTERFACE_NAME", this.itf);
            }
            if (this.service != null) {
                props.put("SERVICE_NAME", this.service);
                if (this.endpoint != null) {
                    props.put("ENDPOINT_NAME", this.endpoint);
                }
            }
            this.reference = this.nmr.getEndpointRegistry().lookup(props);
        }
        return this.reference;
    }

    public Class getObjectType() {
        return Reference.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.nmr == null) {
            if (this.bundleContext == null) {
                throw new IllegalArgumentException("nmr not set while bundleContext is null");
            }
            OsgiServiceProxyFactoryBean factory = new OsgiServiceProxyFactoryBean();
            factory.setInterfaces(new Class[]{NMR.class});
            factory.setBundleContext(this.getBundleContext());
            this.nmr = (NMR)factory.getObject();
        }
        if (this.name == null && this.itf == null && this.service == null) {
            throw new IllegalArgumentException("one of name, interface or service should be set");
        }
    }
}

