/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.p2.internal.deploy.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.p2.internal.deploy.server.IMetadataProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MetadataProcessor
implements IMetadataProcessor {
    private static final Log LOG = LogFactory.getLog(MetadataProcessor.class);
    private static final String CR = System.getProperty("line.separator");
    static final String MARK_BUNDLE_STARTUP = "markStarted(started: true);";
    static final String UNMARK_BUNDLE_STARTUP = "markStarted(started: false);";
    private static final String QUERY_ALL_BUNDLES = "//unit[(count(provides/provided[@namespace='osgi.bundle']) = 1) and (count(provides/provided[@namespace='osgi.fragment']) = 0)]";
    private static final String QUERY_INSTRUCTIONS = "touchpointData/instructions/instruction[@key='";
    private static final String PHASE_CONFIGURE = "configure";
    private static final String PHASE_UNCONFIGURE = "unconfigure";
    private static final String CLOSE_EXPR = "']";
    private static final String KEY = "key";
    private static final String INSTRUCTION = "instruction";
    private static final String INSTRUCTIONS = "instructions";
    private static final String TOUCHPOINT_DATA = "touchpointData";
    private static final String SIZE = "size";
    private static final String CONTENT_XML = "content.xml";
    private static final String CONTENT_JAR = "content.jar";
    private DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    private NodeList emptyList;

    public void updateMetaData(File metadata) throws IOException {
        File repoFile = this.getInputFile(metadata);
        LOG.info((Object)"Adding instructions to metadata");
        Document processed = this.addInstructions(this.getInputStream(repoFile));
        LOG.info((Object)"Write modified metadata to disk");
        this.saveDocument(processed, repoFile);
        LOG.info((Object)"Finished update of metadata");
    }

    final void saveDocument(Document docToSave, File metadataFile) throws IOException {
        if (this.isXml(metadataFile)) {
            this.saveXml(docToSave, metadataFile);
        } else if (this.isJar(metadataFile)) {
            this.saveJar(docToSave, metadataFile);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final InputStream getInputStream(File inputFile) throws IOException {
        void var2_5;
        Object var2_2 = null;
        if (this.isXml(inputFile)) {
            FileInputStream fileInputStream = new FileInputStream(inputFile);
            return var2_5;
        } else {
            if (!this.isJar(inputFile)) throw new IllegalArgumentException("The file " + inputFile + " is invalid");
            ZipInputStream zin = new ZipInputStream(new FileInputStream(inputFile));
            ZipEntry zentry = zin.getNextEntry();
            if (!zentry.getName().endsWith(CONTENT_XML)) throw new IOException("Invalid metadata repository " + inputFile.getPath());
            ZipInputStream zipInputStream = zin;
        }
        return var2_5;
    }

    final Document addInstructions(InputStream metaDataStream) throws IOException {
        Document metadataDoc = this.inputStreamToDocument(metaDataStream);
        NodeList bundleNodes = this.findAllBundles(metadataDoc);
        int entry = 0;
        while (entry < bundleNodes.getLength()) {
            Node bundle = bundleNodes.item(entry);
            if (this.needsStartup(bundle)) {
                this.addBundleStart(bundle);
            }
            if (this.needsShutdown(bundle)) {
                this.addBundleStop(bundle);
            }
            ++entry;
        }
        return metadataDoc;
    }

    final Document inputStreamToDocument(InputStream is) throws IOException {
        Document doc = null;
        try {
            try {
                doc = this.docBuilderFactory.newDocumentBuilder().parse(is);
            }
            catch (ParserConfigurationException e) {
                this.logAndRethrowAsIOException("Problems with XML parser configuration", e);
                is.close();
            }
            catch (SAXException e) {
                this.logAndRethrowAsIOException("Problems with XML parser", e);
                is.close();
            }
        }
        finally {
            is.close();
        }
        return doc;
    }

    final String documentToString(Document doc, boolean isSimpleOutput) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.document2OutputStream(doc, isSimpleOutput, bos);
        return new String(bos.toByteArray(), "UTF-8");
    }

    final void document2OutputStream(Document doc, boolean isSimpleOutput, OutputStream sink) throws IOException {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer t = tf.newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            if (!isSimpleOutput) {
                t.setOutputProperty("method", "xml");
                t.setOutputProperty("indent", "yes");
            }
            StreamResult sr = new StreamResult(sink);
            t.transform(new DOMSource(doc), sr);
        }
        catch (TransformerException e) {
            this.logAndRethrowAsIOException("Error serializing document", e);
        }
    }

    final NodeList findAllBundles(Node root) {
        return this.query(root, QUERY_ALL_BUNDLES);
    }

    final boolean needsStartup(Node item) {
        return !this.isMatchingRequirement(item, PHASE_CONFIGURE, MARK_BUNDLE_STARTUP);
    }

    final boolean needsShutdown(Node item) {
        return !this.isMatchingRequirement(item, PHASE_UNCONFIGURE, UNMARK_BUNDLE_STARTUP);
    }

    final Node addBundleStart(Node bundle) {
        return this.addInstruction(bundle, PHASE_CONFIGURE, MARK_BUNDLE_STARTUP);
    }

    final Node addBundleStop(Node bundle) {
        return this.addInstruction(bundle, PHASE_UNCONFIGURE, UNMARK_BUNDLE_STARTUP);
    }

    private final File getInputFile(File metadata) throws IOException {
        File repo = metadata;
        boolean isRepositoryFound = false;
        if (metadata.isDirectory()) {
            String[] repoList = new String[]{CONTENT_JAR, CONTENT_XML};
            int i = 0;
            while (i < repoList.length && !isRepositoryFound) {
                repo = new File(String.valueOf(metadata.getPath()) + File.separator + repoList[i]);
                isRepositoryFound = repo.exists();
                LOG.info((Object)("Repository @ " + repo.getPath() + " => " + isRepositoryFound));
                ++i;
            }
            if (!isRepositoryFound) {
                String message = "No repository found in directory " + metadata;
                LOG.error((Object)message);
                throw new IOException(message);
            }
        }
        return repo;
    }

    private final void saveJar(Document metadataDoc, File metadataFile) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(metadataFile));
        try {
            try {
                ZipEntry contentEntry = new ZipEntry(CONTENT_XML);
                zos.putNextEntry(contentEntry);
                this.document2OutputStream(metadataDoc, false, zos);
            }
            catch (IOException iox) {
                LOG.error((Object)("Error saving meta data to " + metadataFile));
                throw iox;
            }
        }
        catch (Throwable throwable) {
            try {
                zos.closeEntry();
            }
            catch (IOException iOException) {}
            zos.close();
            throw throwable;
        }
        try {
            zos.closeEntry();
        }
        catch (IOException iOException) {}
        zos.close();
    }

    private final void saveXml(Document metadataDoc, File metadataFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(metadataFile);
        try {
            try {
                this.document2OutputStream(metadataDoc, false, fos);
            }
            catch (IOException iox) {
                LOG.error((Object)("Error saving meta data to " + metadataFile));
                throw iox;
            }
        }
        finally {
            fos.close();
        }
    }

    private final boolean isMatchingRequirement(Node item, String phase, String expectedInstr) {
        boolean matchesReq = false;
        NodeList instructions = this.query(item, QUERY_INSTRUCTIONS + phase + CLOSE_EXPR);
        if (instructions.getLength() == 0) {
            return matchesReq;
        }
        int in = 0;
        while (in < instructions.getLength() && !matchesReq) {
            Node instruction = instructions.item(in);
            Node instrTextNode = this.getTextNode(instruction);
            if (instrTextNode != null) {
                String instr = instrTextNode.getNodeValue();
                instr = instr.replaceAll(" ", "").replaceAll(CR, "");
                matchesReq = instr.contains(expectedInstr.replaceAll(" ", ""));
            }
            ++in;
        }
        return matchesReq;
    }

    private final Node addInstruction(Node bundle, String phase, String instructionCode) {
        String val;
        Element instruction;
        String instructionQuery;
        Element touchPointDataElem = this.getOrCreateChild(bundle, TOUCHPOINT_DATA);
        Element instructionsElem = this.getOrCreateChild(touchPointDataElem, INSTRUCTIONS);
        NodeList instrucList = this.query(instructionsElem, instructionQuery = "instruction[@key = '" + phase + CLOSE_EXPR);
        if (instrucList.getLength() == 0) {
            instruction = this.appendChild(instructionsElem, INSTRUCTION);
            instruction.setAttribute(KEY, phase);
            instruction.appendChild(instruction.getOwnerDocument().createTextNode(""));
        } else {
            instruction = (Element)instrucList.item(0);
        }
        Node instructionTextNode = this.getTextNode(instruction);
        if (instructionTextNode == null) {
            instructionTextNode = instruction.appendChild(instruction.getOwnerDocument().createTextNode(""));
        }
        if ("".equals(val = instructionTextNode.getNodeValue()) || val == null) {
            instructionTextNode.setNodeValue(instructionCode);
        } else {
            String delimiter = val.replaceAll(" ", "").replaceAll(CR, "").endsWith(";") ? "" : ";";
            instructionTextNode.setNodeValue(String.valueOf(val) + delimiter + instructionCode);
        }
        int iCounter = this.query(instructionsElem, INSTRUCTION).getLength();
        instructionsElem.setAttribute(SIZE, "" + iCounter);
        int tdCounter = this.query(touchPointDataElem, INSTRUCTIONS).getLength();
        touchPointDataElem.setAttribute(SIZE, "" + tdCounter);
        return bundle;
    }

    private final Node getTextNode(Node parent) {
        NodeList childs = parent.getChildNodes();
        Node result = null;
        int i = 0;
        while (i < childs.getLength() && result == null) {
            if (childs.item(i).getNodeType() == 3) {
                result = childs.item(i);
            }
            ++i;
        }
        return result;
    }

    private final Element getOrCreateChild(Node parent, String childName) {
        NodeList childNodes = this.query(parent, childName);
        Element childElem = childNodes.getLength() == 0 ? this.appendChild(parent, childName) : (Element)childNodes.item(0);
        return childElem;
    }

    private final Element appendChild(Node parent, String childName) {
        Element e = parent.getOwnerDocument().createElement(childName);
        parent.appendChild(e);
        return e;
    }

    private final NodeList query(Node item, String queryString) {
        NodeList result = null;
        try {
            result = this.getEmptyList();
            result = (NodeList)this.createQuery(queryString).evaluate(item, XPathConstants.NODESET);
        }
        catch (Exception e) {
            LOG.warn((Object)("Query failed: " + queryString), (Throwable)e);
        }
        return result;
    }

    private final XPathExpression createQuery(String expression) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr = xpath.compile(expression);
        return expr;
    }

    private final NodeList getEmptyList() throws ParserConfigurationException {
        if (this.emptyList == null) {
            this.emptyList = this.docBuilderFactory.newDocumentBuilder().newDocument().getChildNodes();
        }
        return this.emptyList;
    }

    private void logAndRethrowAsIOException(String message, Exception ex) throws IOException {
        LOG.error((Object)message, (Throwable)ex);
        throw new IOException(String.valueOf(message) + ": " + ex);
    }

    private final boolean isXml(File inputFile) {
        return inputFile.getName().endsWith(CONTENT_XML);
    }

    private final boolean isJar(File inputFile) {
        return inputFile.getName().endsWith(CONTENT_JAR);
    }
}

