/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.p2.internal.deploy.server;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swordfish.p2.deploy.server.IDirector;
import org.eclipse.swordfish.p2.internal.deploy.server.InstallableUnits;
import org.eclipse.swordfish.p2.internal.deploy.server.Messages;

public class ProvisioningServlet
extends HttpServlet {
    static final String INDENTION = "  ";
    public static final String PARAM_IU_OPERATION = "iuOperation";
    public static final String OPERATION_INSTALL = "install";
    public static final String OPERATION_UPDATE = "update";
    public static final String OPERATION_REMOVE = "remove";
    public static final String PARAM_IU_VERSION = "iuVersion";
    public static final String PARAM_IU_ID = "iuId.";
    public static final String PARAM_IU_TARGET_PROFILE = "iuTargetProfile";
    public static final String DEFAULT_PROFILE = "Swordfish";
    static final String NEW_LINE = System.getProperty("line.separator", "\n");
    private static final String READABLE_OPERATION = "{0}" + NEW_LINE + "{1}";
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(ProvisioningServlet.class);
    private IDirector director;

    public void setDirector(IDirector director) {
        this.director = director;
    }

    IDirector getDirector() {
        return this.director;
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String iuTargetProfile = this.getSaveParameter(req, PARAM_IU_TARGET_PROFILE, DEFAULT_PROFILE);
            String reqInstall = req.getHeader(OPERATION_INSTALL);
            String reqUpdate = req.getHeader(OPERATION_UPDATE);
            String reqRemove = req.getHeader(OPERATION_REMOVE);
            ProvisioningServlet.logOperations(reqInstall, reqUpdate, reqRemove, iuTargetProfile);
            InstallableUnits toInstall = new InstallableUnits(reqInstall);
            InstallableUnits toUpdate = new InstallableUnits(reqUpdate);
            InstallableUnits toRemove = new InstallableUnits(reqRemove);
            if (toInstall.isEmpty() && toUpdate.isEmpty() && toRemove.isEmpty()) {
                throw new ServletException(Messages.Servlet_Missing_Operation);
            }
            SwordfishProvisioningStatus resultStatus = new SwordfishProvisioningStatus(reqInstall, reqUpdate, reqRemove);
            this.director.deploy(resultStatus, toInstall, toUpdate, toRemove, (InputStream)req.getInputStream(), iuTargetProfile);
            if (!resultStatus.isOK()) {
                this.sendError(resp, resultStatus.getFormatedErrorMessage());
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Request failed due to unexpected exception", (Throwable)e);
            }
            this.sendError(resp, e.toString());
        }
    }

    final String getSaveParameter(HttpServletRequest request, String parameter, String defaultValue) throws ServletException {
        String value;
        String string = value = !this.isEmpty(request.getHeader(parameter)) ? request.getHeader(parameter) : defaultValue;
        if (this.isEmpty(value)) {
            throw new ServletException("Value for parameter '" + parameter + "' missing: '" + value + "'");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got parameter '" + parameter + "' with value '" + value + "'"));
        }
        return value;
    }

    void sendError(HttpServletResponse resp, String error) throws IOException {
        LOG.error((Object)error);
        resp.sendError(400, error);
    }

    private static final void logOperations(String install, String update, String remove, String profile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Profile: " + profile));
            LOG.debug((Object)("remove: " + remove));
            LOG.debug((Object)("update: " + update));
            LOG.debug((Object)("install: " + install));
        }
    }

    private final boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    public static class SwordfishProvisioningStatus
    extends MultiStatus {
        private String[] operations;

        public SwordfishProvisioningStatus(int code, String iusToInstall, String iusToUpdate, String iusToRemove) {
            super("org.eclipse.swordfish.p2.deploy.server", 0, "", null);
            this.operations = new String[]{iusToInstall, iusToUpdate, iusToRemove};
        }

        public SwordfishProvisioningStatus(String iusToInstall, String iusToUpdate, String iusToRemove) {
            this(0, iusToInstall, iusToUpdate, iusToRemove);
        }

        public String getMessage() {
            String baseMessage = this.matches(4) ? Messages.Status_Request_Failed : Messages.Status_Request_Successful;
            return NLS.bind((String)baseMessage, (Object)this.getOperationsList());
        }

        protected String getFormatedErrorMessage() {
            return MessageFormat.format(READABLE_OPERATION, this.getMessage(), this.flattenStatus(this.getChildren(), ProvisioningServlet.INDENTION));
        }

        private String getOperationsList() {
            String[] op = new String[]{ProvisioningServlet.OPERATION_INSTALL, ProvisioningServlet.OPERATION_UPDATE, ProvisioningServlet.OPERATION_REMOVE};
            StringBuilder opList = new StringBuilder();
            String delim = "";
            int i = 0;
            while (i < op.length) {
                opList.append(delim).append(op[i]).append("(").append(this.operations[i]).append(")");
                delim = ", ";
                ++i;
            }
            return opList.toString();
        }

        private String flattenStatus(IStatus[] children, String indent) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (children != null && i < children.length) {
                sb.append(indent).append(children[i].getMessage()).append(NEW_LINE);
                sb.append(this.flattenStatus(children[i].getChildren(), String.valueOf(indent) + ProvisioningServlet.INDENTION));
                ++i;
            }
            return sb.toString();
        }
    }
}

