/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.exporter.support;

import java.util.Map;
import org.osgi.framework.ServiceRegistration;
import org.springframework.osgi.service.exporter.OsgiServiceRegistrationListener;
import org.springframework.osgi.service.exporter.support.AbstractDependentServiceExporter;
import org.springframework.osgi.service.exporter.support.ServiceRegistrationDecorator;

public abstract class AbstractOsgiServiceExporter
extends AbstractDependentServiceExporter {
    private OsgiServiceRegistrationListener[] listeners = new OsgiServiceRegistrationListener[0];

    ServiceRegistration notifyListeners(Object service, Map properties, ServiceRegistration registration) {
        this.callRegisteredOnListeners(service, properties);
        return new ServiceRegistrationDecorator(service, registration, this.listeners);
    }

    private void callRegisteredOnListeners(Object service, Map properties) {
        for (int i = 0; i < this.listeners.length; ++i) {
            if (this.listeners[i] == null) continue;
            try {
                this.listeners[i].registered(service, properties);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void setListeners(OsgiServiceRegistrationListener[] listeners) {
        if (listeners != null) {
            this.listeners = listeners;
        }
    }
}

