/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.policy.extractor;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.neethi.Policy;
import org.eclipse.swordfish.core.Interceptor;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.core.planner.Planner;
import org.eclipse.swordfish.core.resolver.policy.DomBasedWsPolicyDefinitionDescription;
import org.eclipse.swordfish.core.resolver.policy.PolicyDefinitionDescription;
import org.eclipse.swordfish.core.resolver.policy.PolicyDescription;
import org.eclipse.swordfish.core.resolver.policy.PolicyExtractor;
import org.eclipse.swordfish.core.resolver.policy.PolicyRole;
import org.eclipse.swordfish.core.resolver.policy.PolicyStatus;
import org.eclipse.swordfish.core.resolver.policy.StreamBasedWsPolicyDefinitionDescription;
import org.eclipse.swordfish.internal.resolver.policy.definitions.WsPolicyDOMDefinition;
import org.eclipse.swordfish.internal.resolver.policy.definitions.WsPolicyStreamDefinition;
import org.eclipse.swordfish.internal.resolver.policy.helpers.WsPolicyBuilder;
import org.eclipse.swordfish.internal.resolver.policy.processor.WsPolicyDescription;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsPolicyExtractor
implements PolicyExtractor,
InitializingBean {
    private WsPolicyBuilder policyBuilder;
    private Planner planner;

    public Policy extractPolicy(Element element) {
        PolicyDescription<Policy> policy = this.doExtractPolicy(new WsPolicyDOMDefinition(null, element));
        return (Policy)policy.getPolicy();
    }

    public Policy extractPolicy(InputStream inputStream) {
        PolicyDescription<Policy> policy = this.doExtractPolicy(new WsPolicyStreamDefinition(null, inputStream));
        return (Policy)policy.getPolicy();
    }

    public PolicyDescription<Policy> extractPolicy(PolicyDefinitionDescription policyDefinition) {
        if (policyDefinition != null) {
            if (policyDefinition instanceof StreamBasedWsPolicyDefinitionDescription) {
                return this.doExtractPolicy((StreamBasedWsPolicyDefinitionDescription)policyDefinition);
            }
            if (policyDefinition instanceof DomBasedWsPolicyDefinitionDescription) {
                return this.doExtractPolicy((DomBasedWsPolicyDefinitionDescription)policyDefinition);
            }
        }
        throw new IllegalArgumentException("Bad policy definition argument provided. ");
    }

    public Class<Policy> getPlatformPolicyType() {
        return Policy.class;
    }

    public boolean isSupportedType(Class<? extends PolicyDefinitionDescription> type) {
        return StreamBasedWsPolicyDefinitionDescription.class.isAssignableFrom(type) || DomBasedWsPolicyDefinitionDescription.class.isAssignableFrom(type);
    }

    private PolicyDescription<Policy> doExtractPolicy(StreamBasedWsPolicyDefinitionDescription policyDefinition) {
        try {
            this.configurePolicyBuilder();
            Policy policy = this.policyBuilder.buildPolicy(policyDefinition.getPolicyStream());
            WsPolicyDescription p = new WsPolicyDescription();
            p.setPolicy(policy);
            p.setPolicyRole(PolicyRole.UNKNOWN);
            p.setPolicyStatus(PolicyStatus.UNKNOWN);
            return p;
        }
        catch (Exception e) {
            throw new SwordfishException("Corrupted policy. ", (Throwable)e);
        }
    }

    private PolicyDescription<Policy> doExtractPolicy(DomBasedWsPolicyDefinitionDescription policyDefinition) {
        try {
            this.configurePolicyBuilder();
            Policy policy = this.policyBuilder.buildPolicy(policyDefinition.getPolicyElement());
            WsPolicyDescription p = new WsPolicyDescription();
            p.setPolicy(policy);
            p.setPolicyRole(PolicyRole.UNKNOWN);
            p.setPolicyStatus(PolicyStatus.UNKNOWN);
            return p;
        }
        catch (Exception e) {
            throw new SwordfishException("Corrupted policy. ", (Throwable)e);
        }
    }

    private void configurePolicyBuilder() {
        HashSet<QName> knownElements = new HashSet<QName>();
        for (Interceptor interceptor : this.planner.getRegisteredInterceptors()) {
            Map props = interceptor.getProperties();
            if (!props.containsKey("type") || !(props.get("type") instanceof QName)) continue;
            knownElements.add((QName)props.get("type"));
        }
        this.policyBuilder.registerPolicyAssertions(knownElements);
        this.policyBuilder.setPolicyNamespace("http://schemas.xmlsoap.org/ws/2004/09/policy");
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.policyBuilder, (String)"Policy builder must be initialized");
        Assert.notNull((Object)this.planner, (String)"Planner must be initialized");
    }

    public WsPolicyBuilder getPolicyBuilder() {
        return this.policyBuilder;
    }

    public void setPolicyBuilder(WsPolicyBuilder policyBuilder) {
        this.policyBuilder = policyBuilder;
    }

    public Planner getPlanner() {
        return this.planner;
    }

    public void setPlanner(Planner planner) {
        this.planner = planner;
    }
}

