/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.support;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.DelegatingEntityResolver;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.core.CollectionFactory;
import org.springframework.osgi.util.BundleDelegatingClassLoader;
import org.springframework.osgi.util.OsgiStringUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NamespacePlugins
implements NamespaceHandlerResolver,
EntityResolver,
DisposableBean {
    private static final Log log = LogFactory.getLog((Class)NamespacePlugins.class);
    private final Map plugins = CollectionFactory.createConcurrentMap((int)5);

    public void addHandler(Bundle bundle) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding as handler " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle)));
        }
        this.plugins.put(bundle, new Plugin(bundle));
    }

    public boolean removeHandler(Bundle bundle) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing handler " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle)));
        }
        return this.plugins.remove(bundle) != null;
    }

    public NamespaceHandler resolve(String namespaceUri) {
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("trying to resolving namespace handler for " + namespaceUri));
        }
        Iterator i = this.plugins.values().iterator();
        while (i.hasNext()) {
            Plugin plugin = (Plugin)i.next();
            try {
                NamespaceHandler handler = plugin.resolve(namespaceUri);
                if (handler == null) continue;
                if (debug) {
                    log.debug((Object)("namespace handler for " + namespaceUri + " found inside " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)plugin.getBundle())));
                }
                return handler;
            }
            catch (IllegalArgumentException ex) {
                if (!debug) continue;
                log.debug((Object)("namespace handler for " + namespaceUri + " not found inside " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)plugin.getBundle())));
            }
        }
        return null;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("trying to resolving entity for " + publicId + "|" + systemId));
        }
        if (systemId != null) {
            Iterator i = this.plugins.values().iterator();
            while (i.hasNext()) {
                Plugin plugin = (Plugin)i.next();
                try {
                    InputSource is = plugin.resolveEntity(publicId, systemId);
                    if (is == null) continue;
                    if (debug) {
                        log.debug((Object)("XML schema for " + publicId + "|" + systemId + " found inside " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)plugin.getBundle())));
                    }
                    return is;
                }
                catch (FileNotFoundException ex) {
                    if (!debug) continue;
                    log.debug((Object)("XML schema for " + publicId + "|" + systemId + " not found inside " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)plugin.getBundle())), (Throwable)ex);
                }
            }
        }
        return null;
    }

    public void destroy() {
        this.plugins.clear();
    }

    private static class Plugin
    implements NamespaceHandlerResolver,
    EntityResolver {
        private final NamespaceHandlerResolver namespace;
        private final EntityResolver entity;
        private final Bundle bundle;

        private Plugin(Bundle bundle) {
            this.bundle = bundle;
            BundleDelegatingClassLoader loader = BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)bundle);
            this.entity = new DelegatingEntityResolver((ClassLoader)loader);
            this.namespace = new DefaultNamespaceHandlerResolver((ClassLoader)loader);
        }

        public NamespaceHandler resolve(String namespaceUri) {
            return this.namespace.resolve(namespaceUri);
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return this.entity.resolveEntity(publicId, systemId);
        }

        public Bundle getBundle() {
            return this.bundle;
        }
    }
}

