/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.p2.internal.deploy.server;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.swordfish.p2.internal.deploy.server.IOperationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOperationSupport
implements IOperationSupport {
    public static final Log LOG = LogFactory.getLog(AbstractOperationSupport.class);
    protected ProvisioningSession session;

    abstract ProfileChangeOperation newProfileChangeOperation(Collection<IInstallableUnit> var1);

    @Override
    public void provision(MultiStatus status, Collection<IInstallableUnit> units, IProfile profile, ProvisioningContext provContext, IProgressMonitor monitor) {
        AbstractOperationSupport.log("Enter provision for " + this.getOperationName(), units, profile);
        if (!units.isEmpty()) {
            ProfileChangeOperation op = this.newProfileChangeOperation(units);
            op.setProvisioningContext(provContext);
            op.setProfileId(profile.getProfileId());
            this.runOperationModal(status, op, monitor);
        }
    }

    private void runOperationModal(MultiStatus status, ProfileChangeOperation op, IProgressMonitor monitor) {
        status.merge(op.resolveModal(monitor));
        if (status.isOK()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("run provisioning job " + op));
            }
            status.merge(op.getProvisioningJob(monitor).run(monitor));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("runOperationModal returns " + status));
        }
    }

    public String toString() {
        return "OperationSupport for" + this.getOperationName();
    }

    public final void setProvisioningAgent(IProvisioningAgent agent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("set provisioning agent " + agent));
        }
        this.session = agent != null ? new ProvisioningSession(agent) : null;
    }

    private static final void log(String message, Collection<IInstallableUnit> units, IProfile profile) {
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            String delim = "";
            for (IInstallableUnit unit : units) {
                sb.append(delim).append(unit.getId());
                delim = ",";
            }
            LOG.debug((Object)(String.valueOf(message) + "(" + sb.toString() + "," + profile));
        }
    }
}

