/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.planner;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jbi.messaging.MessageExchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.Interceptor;
import org.eclipse.swordfish.core.planner.Planner;
import org.eclipse.swordfish.core.planner.strategy.FilterStrategy;
import org.eclipse.swordfish.core.planner.strategy.Hint;
import org.eclipse.swordfish.core.planner.strategy.HintExtractor;
import org.eclipse.swordfish.core.planner.strategy.SortingStrategy;
import org.eclipse.swordfish.core.util.ReadOnlyRegistry;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlannerImpl
implements Planner,
ManagedService {
    private static final Log LOG = LogFactory.getLog(PlannerImpl.class);
    private ReadOnlyRegistry<Interceptor> interceptorRegistry;
    private HintExtractor hintExtractor;
    private FilterStrategy filterStrategy;
    private SortingStrategy sortingStrategy;

    public List<Interceptor> getInterceptorChain(Set<Interceptor> interceptors, MessageExchange messageExchange) {
        List<Hint<?>> hints = this.hintExtractor.extractHints(messageExchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Filtering the interceptors with the followng list of hints: " + hints));
        }
        ArrayList<Interceptor> interceptorList = new ArrayList<Interceptor>(interceptors);
        List<Interceptor> filtered = this.filterStrategy.filter(interceptorList, this.interceptorRegistry, hints);
        HashSet<Interceptor> filteredSet = new HashSet<Interceptor>(filtered);
        List<Interceptor> sorted = this.sortingStrategy.sort(filteredSet, this.interceptorRegistry, messageExchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Prepared list of interceptors:\n %s\n for processing exchange:\n", sorted, messageExchange));
        }
        return sorted;
    }

    public Set<Interceptor> getRegisteredInterceptors() {
        return this.interceptorRegistry.getKeySet();
    }

    public void setSortingStrategy(SortingStrategy sortingStrategy) {
        this.sortingStrategy = sortingStrategy;
    }

    public void setFilterStrategy(FilterStrategy filterStrategy) {
        this.filterStrategy = filterStrategy;
    }

    public void setHintExtractor(HintExtractor hintExtractor) {
        this.hintExtractor = hintExtractor;
    }

    public void setInterceptorRegistry(ReadOnlyRegistry<Interceptor> interceptorRegistry) {
        this.interceptorRegistry = interceptorRegistry;
    }

    public void updated(Dictionary dictionary) throws ConfigurationException {
    }
}

