/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.config;

import java.util.ArrayList;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.Conventions;
import org.springframework.osgi.config.OsgiDefaultsDefinition;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

abstract class ParserUtils {
    private static final AttributeCallback STANDARD_ATTRS_CALLBACK = new StandardAttributeCallback();
    private static final AttributeCallback PROPERTY_REF_ATTRS_CALLBACK = new PropertyRefAttributeCallback();
    private static final AttributeCallback PROPERTY_CONV_ATTRS_CALLBACK = new ConventionCallback();
    private static final String OSGI_NS = "http://www.springframework.org/schema/osgi";
    private static final String DEFAULT_TIMEOUT = "default-timeout";
    private static final String DEFAULT_CARDINALITY = "default-cardinality";

    ParserUtils() {
    }

    public static void parseAttributes(Element element, BeanDefinitionBuilder builder, AttributeCallback[] callbacks) {
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attr = (Attr)attributes.item(x);
            boolean shouldContinue = true;
            if (ObjectUtils.isEmpty((Object[])callbacks)) continue;
            for (int i = 0; i < callbacks.length && shouldContinue; ++i) {
                AttributeCallback callback = callbacks[i];
                shouldContinue = callback.process(element, attr, builder);
            }
        }
    }

    public static void parseCustomAttributes(Element element, BeanDefinitionBuilder builder, AttributeCallback[] callbacks) {
        ArrayList<AttributeCallback> list = new ArrayList<AttributeCallback>(8);
        if (!ObjectUtils.isEmpty((Object[])callbacks)) {
            CollectionUtils.mergeArrayIntoCollection((Object)callbacks, list);
        }
        list.add(STANDARD_ATTRS_CALLBACK);
        list.add(PROPERTY_REF_ATTRS_CALLBACK);
        list.add(PROPERTY_CONV_ATTRS_CALLBACK);
        AttributeCallback[] cbacks = list.toArray(new AttributeCallback[list.size()]);
        ParserUtils.parseAttributes(element, builder, cbacks);
    }

    public static void parseCustomAttributes(Element element, BeanDefinitionBuilder builder, AttributeCallback callback) {
        AttributeCallback[] attributeCallbackArray;
        if (callback == null) {
            attributeCallbackArray = new AttributeCallback[]{};
        } else {
            AttributeCallback[] attributeCallbackArray2 = new AttributeCallback[1];
            attributeCallbackArray = attributeCallbackArray2;
            attributeCallbackArray2[0] = callback;
        }
        AttributeCallback[] callbacks = attributeCallbackArray;
        ParserUtils.parseCustomAttributes(element, builder, callbacks);
    }

    public static OsgiDefaultsDefinition initOsgiDefaults(Document document) {
        Assert.notNull((Object)document);
        return ParserUtils.initOsgiDefaults(document.getDocumentElement());
    }

    public static OsgiDefaultsDefinition initOsgiDefaults(Element root) {
        String cardinality;
        Assert.notNull((Object)root);
        OsgiDefaultsDefinition defaults = new OsgiDefaultsDefinition();
        String timeout = root.getAttributeNS(OSGI_NS, DEFAULT_TIMEOUT);
        if (StringUtils.hasText((String)timeout)) {
            defaults.setTimeout(timeout);
        }
        if (StringUtils.hasText((String)(cardinality = root.getAttributeNS(OSGI_NS, DEFAULT_CARDINALITY)))) {
            defaults.setCardinality(cardinality);
        }
        return defaults;
    }

    public static AttributeCallback[] mergeCallbacks(AttributeCallback[] callbacksA, AttributeCallback[] callbacksB) {
        if (ObjectUtils.isEmpty((Object[])callbacksA)) {
            if (ObjectUtils.isEmpty((Object[])callbacksB)) {
                return new AttributeCallback[0];
            }
            return callbacksB;
        }
        if (ObjectUtils.isEmpty((Object[])callbacksB)) {
            return callbacksA;
        }
        AttributeCallback[] newCallbacks = new AttributeCallback[callbacksA.length + callbacksB.length];
        System.arraycopy(callbacksA, 0, newCallbacks, 0, callbacksA.length);
        System.arraycopy(callbacksB, 0, newCallbacks, callbacksA.length, callbacksB.length);
        return newCallbacks;
    }

    static interface AttributeCallback {
        public boolean process(Element var1, Attr var2, BeanDefinitionBuilder var3);
    }

    static class ConventionCallback
    implements AttributeCallback {
        ConventionCallback() {
        }

        public boolean process(Element parent, Attr attribute, BeanDefinitionBuilder builder) {
            String name = attribute.getLocalName();
            String propertyName = Conventions.attributeNameToPropertyName((String)name);
            builder.addPropertyValue(propertyName, (Object)attribute.getValue());
            return true;
        }
    }

    static class PropertyRefAttributeCallback
    implements AttributeCallback {
        private static final String PROPERTY_REF = "-ref";

        PropertyRefAttributeCallback() {
        }

        public boolean process(Element parent, Attr attribute, BeanDefinitionBuilder builder) {
            String name = attribute.getLocalName();
            if (name.endsWith(PROPERTY_REF)) {
                String propertyName = name.substring(0, name.length() - PROPERTY_REF.length());
                builder.addPropertyReference(propertyName, attribute.getValue());
                return false;
            }
            return true;
        }
    }

    static class StandardAttributeCallback
    implements AttributeCallback {
        StandardAttributeCallback() {
        }

        public boolean process(Element parent, Attr attribute, BeanDefinitionBuilder builder) {
            String name = attribute.getLocalName();
            if ("id".equals(name)) {
                return false;
            }
            if ("depends-on".equals(name)) {
                builder.getBeanDefinition().setDependsOn(StringUtils.tokenizeToStringArray((String)attribute.getValue(), (String)",; "));
                return false;
            }
            if ("lazy-init".equals(name)) {
                builder.setLazyInit(Boolean.getBoolean(attribute.getValue()));
                return false;
            }
            return true;
        }
    }
}

