/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.internal.collection;

import java.util.Comparator;
import java.util.SortedSet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.springframework.osgi.service.importer.internal.aop.ServiceProxyCreator;
import org.springframework.osgi.service.importer.internal.collection.DynamicCollection;
import org.springframework.osgi.service.importer.internal.collection.DynamicSortedSet;
import org.springframework.osgi.service.importer.internal.collection.OsgiServiceSet;

public class OsgiServiceSortedSet
extends OsgiServiceSet
implements SortedSet {
    private SortedSet storage;
    private final Comparator comparator;

    public OsgiServiceSortedSet(Filter filter, BundleContext context, ClassLoader classLoader, ServiceProxyCreator proxyCreator) {
        this(filter, context, classLoader, null, proxyCreator);
    }

    public OsgiServiceSortedSet(Filter filter, BundleContext context, ClassLoader classLoader, Comparator comparator, ServiceProxyCreator proxyCreator) {
        super(filter, context, classLoader, proxyCreator);
        this.comparator = comparator;
    }

    protected DynamicCollection createInternalDynamicStorage() {
        this.storage = new DynamicSortedSet(this.comparator);
        return (DynamicCollection)((Object)this.storage);
    }

    public Comparator comparator() {
        return this.storage.comparator();
    }

    public Object first() {
        this.mandatoryServiceCheck();
        return this.storage.first();
    }

    public Object last() {
        this.mandatoryServiceCheck();
        return this.storage.last();
    }

    public SortedSet tailSet(Object fromElement) {
        this.mandatoryServiceCheck();
        return this.storage.tailSet(fromElement);
    }

    public SortedSet headSet(Object toElement) {
        this.mandatoryServiceCheck();
        return this.storage.headSet(toElement);
    }

    public SortedSet subSet(Object fromElement, Object toElement) {
        this.mandatoryServiceCheck();
        return this.storage.subSet(fromElement, toElement);
    }
}

