/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.management;

import java.util.HashMap;
import java.util.Map;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.management.stats.CountStatistic;
import org.apache.servicemix.nmr.management.stats.TimeStatistic;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(description="Managed Endpoint", currencyTimeLimit=15)
public class ManagedEndpoint {
    protected final InternalEndpoint endpoint;
    protected final Map<String, ?> properties;
    protected final CountStatistic inboundExchanges;
    protected final CountStatistic outboundExchanges;
    protected final TimeStatistic inboundExchangeRate;
    protected final TimeStatistic outboundExchangeRate;

    public ManagedEndpoint(InternalEndpoint endpoint, Map<String, ?> properties) {
        this.endpoint = endpoint;
        this.properties = new HashMap(properties);
        this.inboundExchanges = new CountStatistic("inboundExchanges", "Number of exchanges received");
        this.inboundExchangeRate = new TimeStatistic("inboundExchangeRate", "Number of exchanges received per second");
        this.outboundExchanges = new CountStatistic("outboundExchanges", "Number of exchanges sent");
        this.outboundExchangeRate = new TimeStatistic("outboundExchangeRate", "Number of exchanges sent per second");
    }

    public InternalEndpoint getEndpoint() {
        return this.endpoint;
    }

    void incrementInbound() {
        this.inboundExchanges.increment();
        this.inboundExchangeRate.addTime();
    }

    void incrementOutbound() {
        this.outboundExchanges.increment();
        this.outboundExchangeRate.addTime();
    }

    @ManagedAttribute(description="Name of the endpoint")
    public String getName() {
        return (String)this.properties.get("NAME");
    }

    @ManagedAttribute(description="Properties associated to this endpoint")
    public Map<String, ?> getProperties() {
        return this.properties;
    }

    @ManagedAttribute(description="Number of exchanges received")
    public long getInboundExchangeCount() {
        return this.inboundExchanges.getCount();
    }

    @ManagedAttribute(description="Exchanges received per second")
    public double getInboundExchangeRate() {
        return this.inboundExchangeRate.getAveragePerSecond();
    }

    @ManagedAttribute(description="Number of exchanges sent")
    public long getOutboundExchangeCount() {
        return this.outboundExchanges.getCount();
    }

    @ManagedAttribute(description="Exchanges sent per second")
    public double getOutboundExchangeRate() {
        return this.outboundExchangeRate.getAveragePerSecond();
    }

    @ManagedOperation
    public void reset() {
        this.inboundExchanges.reset();
        this.outboundExchanges.reset();
        this.inboundExchangeRate.reset();
        this.outboundExchangeRate.reset();
    }
}

