/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.registry;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.eclipse.swordfish.registry.DefaultResource;
import org.eclipse.swordfish.registry.IncorrectRequestException;
import org.eclipse.swordfish.registry.ListResource;
import org.eclipse.swordfish.registry.Resource;
import org.eclipse.swordfish.registry.WSDLListHtmlResource;
import org.eclipse.swordfish.registry.WSDLRepository;
import org.eclipse.swordfish.registry.WSDLResourceReader;
import org.eclipse.swordfish.registry.WSILResource;
import org.eclipse.swordfish.registry.domain.Definition;

public class Router {
    private WSDLRepository repository;
    private WSDLResourceReader wsdlResourceReader;

    public void setRepository(WSDLRepository repository) {
        this.repository = repository;
    }

    public void setWsdlResourceReader(WSDLResourceReader wsdlResourceReader) {
        this.wsdlResourceReader = wsdlResourceReader;
    }

    public Resource getResource(HttpServletRequest req) throws IncorrectRequestException {
        if (req.getServletPath().endsWith("wsil")) {
            return this.getWSILResource(req);
        }
        if (req.getServletPath().endsWith("wsdl")) {
            return this.getWSDLListResource(req);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Resource getWSILResource(HttpServletRequest req) throws IncorrectRequestException {
        IdIterable identifiers = null;
        if (req.getParameterMap().isEmpty()) {
            String resourceId = Router.getResourceId(req);
            if (resourceId != null) throw new IncorrectRequestException(404, "");
            identifiers = new IdIterable(this.repository.getAllWSDLDefinitions());
            return new WSILResource(Router.getBaseUrl(req), identifiers);
        } else {
            String type = req.getParameter("type");
            if (type == null) {
                throw new IncorrectRequestException(400, "If using query paramters the parameter 'type' is mandatory");
            }
            if ("portType".equals(type)) {
                String portTypeName = req.getParameter("name");
                String targetNameSpace = req.getParameter("targetNamespace");
                if (portTypeName == null || targetNameSpace == null) {
                    throw new IncorrectRequestException(400, "If the query parameter type is set to portType also the query parameters name and targetNamespace have to be defined");
                }
                identifiers = new IdIterable(this.repository.getWSDLDefinitionsByPortType(new QName(targetNameSpace, portTypeName)));
                return new WSILResource(Router.getBaseUrl(req), identifiers);
            } else {
                if (!"service".equals(type)) throw new IncorrectRequestException(400, "Only the values portType and service are accepted for the query parameter type");
                String portTypeNamespace = req.getParameter("refPortTypeNamespace");
                String portTypeName = req.getParameter("refPortTypeName");
                if (portTypeNamespace == null || portTypeName == null) {
                    throw new IncorrectRequestException(400, "If the query parameter type is set to service also the query parameters refPortTypeNamespace and refPortTypeName have to be defined");
                }
                identifiers = new IdIterable(this.repository.getWSDLDefinitionsByServiceReferencingPortType(new QName(portTypeNamespace, portTypeName)));
            }
        }
        return new WSILResource(Router.getBaseUrl(req), identifiers);
    }

    public Resource getWSDLListResource(HttpServletRequest req) throws IncorrectRequestException {
        DefaultResource resource = null;
        if (req.getParameterMap().isEmpty()) {
            String resourceId = Router.getResourceId(req);
            if (resourceId == null) {
                String acceptHeader = req.getHeader("Accept");
                if (acceptHeader != null && acceptHeader.contains("text/html")) {
                    resource = new WSDLListHtmlResource(Router.getBaseUrl(req), this.repository);
                } else {
                    Iterable<Definition> definitions = this.repository.getAllWSDLDefinitions();
                    resource = new ListResource<Definition>(definitions);
                }
            } else {
                resource = this.wsdlResourceReader.getResource(resourceId);
                if (resource == null) {
                    throw new IncorrectRequestException(404, "");
                }
            }
        } else {
            String type = req.getParameter("type");
            if (type == null) {
                throw new IncorrectRequestException(400, "If using query paramters the parameter 'type' is mandatory");
            }
            if ("portType".equals(type)) {
                String portTypeName = req.getParameter("name");
                String targetNameSpace = req.getParameter("targetNamespace");
                if (portTypeName == null || targetNameSpace == null) {
                    throw new IncorrectRequestException(400, "If the query parameter type is set to portType also the query parameters name and targetNamespace have to be defined");
                }
                Iterable<Definition> definitions = this.repository.getWSDLDefinitionsByPortType(new QName(targetNameSpace, portTypeName));
                resource = new ListResource<Definition>(definitions);
            } else if ("service".equals(type)) {
                String portTypeNamespace = req.getParameter("refPortTypeNamespace");
                String portTypeName = req.getParameter("refPortTypeName");
                if (portTypeNamespace == null || portTypeName == null) {
                    throw new IncorrectRequestException(400, "If the query parameter type is set to service also the query parameters refPortTypeNamespace and refPortTypeName have to be defined");
                }
                Iterable<Definition> definitions = this.repository.getWSDLDefinitionsByServiceReferencingPortType(new QName(portTypeNamespace, portTypeName));
                resource = new ListResource<Definition>(definitions);
            } else {
                throw new IncorrectRequestException(400, "Only the values portType and service are accepted for the query parameter type");
            }
        }
        return resource;
    }

    private static String getResourceId(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && pathInfo.length() > 1) {
            return pathInfo.substring(1);
        }
        return null;
    }

    private static String getBaseUrl(HttpServletRequest req) {
        StringBuffer rURL = req.getRequestURL();
        String base = rURL.substring(0, rURL.lastIndexOf("/"));
        return base;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IdIterable
    implements Iterable<String> {
        private final Iterable<Definition> definitions;

        public IdIterable(Iterable<Definition> definitions) {
            this.definitions = definitions;
        }

        @Override
        public Iterator<String> iterator() {
            final Iterator<Definition> defIter = this.definitions.iterator();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return defIter.hasNext();
                }

                @Override
                public String next() {
                    return ((Definition)defIter.next()).getId();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

