/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.core.resolver.EndpointDescription;
import org.eclipse.swordfish.core.resolver.EndpointMetadata;
import org.eclipse.swordfish.core.resolver.ServiceResolver;
import org.eclipse.swordfish.core.resolver.policy.PolicyDefinitionDescription;
import org.eclipse.swordfish.core.resolver.policy.PolicyDefinitionProvider;
import org.eclipse.swordfish.core.resolver.policy.PolicyDescription;
import org.eclipse.swordfish.core.resolver.policy.PolicyDescriptionEndpointMetadata;
import org.eclipse.swordfish.core.resolver.policy.PolicyExtractor;
import org.eclipse.swordfish.core.resolver.policy.PolicyProcessor;
import org.eclipse.swordfish.core.resolver.registry.EndpointDocumentProvider;
import org.eclipse.swordfish.core.resolver.registry.EndpointExtractor;
import org.eclipse.swordfish.core.resolver.registry.ServiceDescription;
import org.eclipse.swordfish.internal.resolver.EndpointExtractorsRegistry;
import org.eclipse.swordfish.internal.resolver.PolicyExtractorsRegistry;
import org.eclipse.swordfish.internal.resolver.ProvidersRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceResolverImpl
implements ServiceResolver {
    private ProvidersRegistry<EndpointDocumentProvider> providersRegistry;
    private EndpointExtractorsRegistry extractorsRegistry;
    private ProvidersRegistry<PolicyDefinitionProvider> policyProvidersRegistry;
    private PolicyExtractorsRegistry policyExtractorsRegistry;
    private PolicyProcessor<?> policyProcessor;

    public List<EndpointDescription> getEndpointsFor(QName portType) {
        return this.getEndpointsFor(portType, null);
    }

    final boolean isPolicySupportActive(QName consumer) {
        return this.policyProvidersRegistry != null && !this.policyProvidersRegistry.isEmpty() && this.policyExtractorsRegistry != null && !this.policyExtractorsRegistry.isEmpty() && this.policyProcessor != null && consumer != null;
    }

    public List<EndpointDescription> getEndpointsFor(QName portType, QName consumer) {
        EndpointDocumentProvider descriptionProvider = this.providersRegistry.getPreferredProvider();
        if (descriptionProvider == null) {
            throw new SwordfishException("Couldn't get endpoints for: " + portType + ", no registered document providers were found");
        }
        ArrayList<EndpointDescription> endpoints = new ArrayList<EndpointDescription>();
        Collection<ServiceDescription<?>> descriptions = descriptionProvider.getServiceProviderDescriptions(portType);
        boolean isPolicySupportActive = this.isPolicySupportActive(consumer);
        PolicyDescription<?> consumerPolicy = null;
        if (isPolicySupportActive) {
            try {
                consumerPolicy = this.queryPolicies(consumer).iterator().next();
            }
            catch (NoSuchElementException e) {
                throw new SwordfishException("Policy support active and no consumer policy assigned.", (Throwable)e);
            }
        } else if (consumer != null) {
            throw new SwordfishException("Policy support requested by consumerbut not available. ");
        }
        if (!descriptions.isEmpty()) {
            block2: for (ServiceDescription<?> description : descriptions) {
                Map<String, PolicyDefinitionDescription> embeddedPolicies = null;
                if (isPolicySupportActive && (embeddedPolicies = description.getEmbeddedPolicyDefinitions()).isEmpty()) {
                    embeddedPolicies = null;
                    QName serviceProviderName = description.getServiceName();
                    List<PolicyDescription<?>> policies = this.queryPolicies(serviceProviderName);
                    PolicyDescription<?> agreed = this.policyProcessor.tradeAgreedPolicy(consumerPolicy, policies);
                    if (agreed == null) continue;
                }
                Collection<EndpointExtractor> extractors = this.extractorsRegistry.getExtractors();
                for (EndpointExtractor endpointExtractor : extractors) {
                    if (!endpointExtractor.canHandle(description)) continue;
                    EndpointDescription ed = endpointExtractor.extractEndpoint(description);
                    if (embeddedPolicies != null) {
                        PolicyDefinitionDescription pdd = embeddedPolicies.get(ed.getName());
                        List<PolicyDescription<?>> policies = this.queryPolicies(pdd);
                        PolicyDescription<?> agreed = this.policyProcessor.tradeAgreedPolicy(consumerPolicy, policies);
                        if (agreed == null) continue;
                        ed.setMetadata((EndpointMetadata)new PolicyDescriptionEndpointMetadata(agreed));
                    }
                    endpoints.add(ed);
                    continue block2;
                }
            }
        }
        return endpoints;
    }

    public EndpointExtractorsRegistry getEndpointExtractorsRegistry() {
        return this.extractorsRegistry;
    }

    public void setEndpointExtractorsRegistry(EndpointExtractorsRegistry extractorsRegistry) {
        this.extractorsRegistry = extractorsRegistry;
    }

    public ProvidersRegistry<EndpointDocumentProvider> getDocumentProvidersRegistry() {
        return this.providersRegistry;
    }

    public void setDocumentProvidersRegistry(ProvidersRegistry<EndpointDocumentProvider> providersRegistry) {
        this.providersRegistry = providersRegistry;
    }

    public PolicyExtractorsRegistry getPolicyExtractorsRegistry() {
        return this.policyExtractorsRegistry;
    }

    public void setPolicyExtractorsRegistry(PolicyExtractorsRegistry policyExtractorsRegistry) {
        this.policyExtractorsRegistry = policyExtractorsRegistry;
    }

    public ProvidersRegistry<PolicyDefinitionProvider> getPolicyProvidersRegistry() {
        return this.policyProvidersRegistry;
    }

    public void setPolicyProvidersRegistry(ProvidersRegistry<PolicyDefinitionProvider> policyProvidersRegistry) {
        this.policyProvidersRegistry = policyProvidersRegistry;
    }

    public PolicyProcessor<?> getPolicyProcessor() {
        return this.policyProcessor;
    }

    public void setPolicyProcessor(PolicyProcessor<?> policyProcessor) {
        this.policyProcessor = policyProcessor;
    }

    private List<PolicyDescription<?>> queryPolicies(QName name) {
        PolicyDefinitionProvider pr = this.policyProvidersRegistry.getPreferredProvider();
        Collection<PolicyDefinitionDescription> policyDefinitions = pr.getPolicyDefinitions(name);
        return this.queryPolicies(policyDefinitions);
    }

    private List<PolicyDescription<?>> queryPolicies(PolicyDefinitionDescription embeddedPolicy) {
        ArrayList<PolicyDefinitionDescription> policyDefinitions = new ArrayList<PolicyDefinitionDescription>(1);
        policyDefinitions.add(embeddedPolicy);
        return this.queryPolicies(policyDefinitions);
    }

    private List<PolicyDescription<?>> queryPolicies(Collection<PolicyDefinitionDescription> policyDefinitions) {
        LinkedList policies = new LinkedList();
        for (PolicyDefinitionDescription pd : policyDefinitions) {
            PolicyExtractor pe = this.policyExtractorsRegistry.getExtractor(pd.getClass(), this.policyProcessor.getPlatformPolicyClass());
            if (pe == null) {
                throw new SwordfishException("Missing policy extractor.");
            }
            PolicyDescription<?> p = pe.extractPolicy(pd);
            if (p == null) continue;
            policies.add(p);
        }
        return policies;
    }
}

