/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.jaas.config.impl;

import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.servicemix.kernel.jaas.boot.ProxyLoginModule;
import org.apache.servicemix.kernel.jaas.config.JaasRealm;
import org.apache.servicemix.kernel.jaas.config.impl.Module;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.context.BundleContextAware;

public class Config
implements JaasRealm,
BundleContextAware {
    private String name;
    private int rank;
    private Module[] modules;
    private BundleContext bundleContext;
    private transient AppConfigurationEntry[] entries;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public Module[] getModules() {
        return this.modules;
    }

    public void setModules(Module[] modules) {
        this.modules = modules;
        this.entries = null;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public AppConfigurationEntry[] getEntries() {
        if (this.entries == null && this.modules != null) {
            Module[] modules = this.modules;
            AppConfigurationEntry[] entries = new AppConfigurationEntry[modules.length];
            for (int i = 0; i < modules.length; ++i) {
                HashMap<String, String> options = new HashMap<String, String>();
                if (modules[i].getOptions() != null) {
                    options.putAll(modules[i].getOptions());
                }
                options.put("org.apache.servicemix.kernel.jaas.module", modules[i].getClassName());
                options.put("org.apache.servicemix.kernel.jaas.bundle", Long.toString(this.bundleContext.getBundle().getBundleId()));
                entries[i] = new AppConfigurationEntry(ProxyLoginModule.class.getName(), this.getControlFlag(modules[i].getFlags()), options);
            }
            this.entries = entries;
        }
        return this.entries;
    }

    private AppConfigurationEntry.LoginModuleControlFlag getControlFlag(String flags) {
        if ("required".equalsIgnoreCase(flags)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if ("optional".equalsIgnoreCase(flags)) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        if ("requisite".equalsIgnoreCase(flags)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        if ("sufficient".equalsIgnoreCase(flags)) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        return null;
    }
}

