/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.plugins.compression;

import java.util.HashMap;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.Interceptor;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.internal.core.util.xml.XmlUtil;
import org.eclipse.swordfish.plugins.compression.CompressionConstants;
import org.eclipse.swordfish.plugins.compression.Compressor;
import org.w3c.dom.DocumentFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompressionInterceptor
implements Interceptor {
    protected static Log LOG = LogFactory.getLog(AbstractCompressionInterceptor.class);
    private static Map<String, Object> properties = new HashMap<String, Object>();
    private Compressor compressor;

    static {
        properties.put("type", new QName("http://www.eclipse.org/swordfish/schemas/policy", "Compression"));
    }

    protected int getSizeProperty(Map<String, Object> contextProperties) {
        String stringSize;
        int size = 0;
        if (contextProperties != null && (stringSize = (String)contextProperties.get("size")) != null) {
            size = new Integer(stringSize);
        }
        return size;
    }

    protected void compress(NormalizedMessage nm, int sizeThreshold) {
        Source src = nm.getContent();
        if (this.getCompressor().isSourceEmpty(src)) {
            LOG.warn((Object)"No payload to compress.");
            return;
        }
        try {
            Source compressed;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Performing compression of normalized message, size threshold is: %d", sizeThreshold));
            }
            if ((compressed = this.getCompressor().asCompressedSource(src, sizeThreshold)) == null) {
                return;
            }
            nm.setContent(compressed);
            this.setCompressionHeader(nm);
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            throw new SwordfishException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void decompress(NormalizedMessage nm) {
        Source src = nm.getContent();
        if (this.getCompressor().isSourceEmpty(src)) {
            LOG.warn((Object)"No payload to decompress.");
            return;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Performing decompression of normalized message");
            }
            Source compressed = this.getCompressor().asUncompressedSource(src);
            nm.setContent(compressed);
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            throw new SwordfishException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void setCompressionHeader(NormalizedMessage nm) {
        HashMap<QName, DocumentFragment> headers = (HashMap<QName, DocumentFragment>)nm.getProperty("org.apache.servicemix.soap.headers");
        if (headers == null) {
            headers = new HashMap<QName, DocumentFragment>();
            nm.setProperty("org.apache.servicemix.soap.headers", headers);
        }
        DocumentFragment compressionHeader = XmlUtil.wrapWithDocumentFragment((String)"<sbb:Compression xmlns:sbb=\"http://types.sopware.org/messaging/headers/1.0\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" soap:mustUnderstand=\"1\"/>");
        headers.put(CompressionConstants.COMPRESSION_QNAME, compressionHeader);
    }

    protected NormalizedMessage getRequestMessage(MessageExchange exchange) {
        return exchange.getMessage("in");
    }

    protected NormalizedMessage getResponseMessage(MessageExchange exchange) {
        return exchange.getMessage("out");
    }

    public void setCompressor(Compressor compressor) {
        this.compressor = compressor;
    }

    public Compressor getCompressor() {
        return this.compressor;
    }

    public Map<String, ?> getProperties() {
        return properties;
    }
}

