/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.util.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.eclipse.swordfish.internal.core.util.xml.XmlUtil;
import org.springframework.util.Assert;
import org.w3c.dom.Node;

public class XPathUtil {
    private static SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();

    public static String getElementByName(String xml, QName elementName) throws IllegalStateException {
        return (String)XPathUtil.getElementByName(xml, elementName, XPathConstants.STRING);
    }

    public static Node getElementByName(Node contextNode, QName elementName) throws IllegalStateException {
        return (Node)XPathUtil.getElementByName(contextNode, elementName, XPathConstants.NODE);
    }

    public static Object getElementByName(String xml, QName elementName, QName returnType) throws IllegalStateException {
        Object[] props = new Object[]{xml, elementName, returnType};
        Assert.noNullElements((Object[])props, (String)"All passed parameters must not be null.");
        return XPathUtil.getElementByNameInternal(XmlUtil.toDOMFromString(xml), elementName, returnType);
    }

    public static Object getElementByName(Node contextNode, QName elementName, QName returnType) throws IllegalStateException {
        Object[] props = new Object[]{contextNode, elementName, returnType};
        Assert.noNullElements((Object[])props, (String)"All passed parameters must not be null.");
        return XPathUtil.getElementByNameInternal(contextNode, elementName, returnType);
    }

    private static Object getElementByNameInternal(Node context, QName elementName, QName returnType) {
        Object res = null;
        try {
            try {
                namespaceContext.add(elementName.getPrefix(), elementName.getNamespaceURI());
                XPathFactory factory = XPathFactory.newInstance();
                XPath xpath = factory.newXPath();
                xpath.setNamespaceContext(namespaceContext);
                String expression = "//";
                if (elementName.getPrefix() != null && !elementName.getPrefix().equals("")) {
                    expression = String.valueOf(expression) + elementName.getPrefix() + ":";
                }
                expression = String.valueOf(expression) + elementName.getLocalPart();
                XPathExpression exp = xpath.compile(expression);
                res = exp.evaluate(context, returnType);
            }
            catch (Exception e) {
                throw new IllegalStateException("Couldn't extract element: " + elementName, e);
            }
        }
        finally {
            namespaceContext.clear();
        }
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleNamespaceContext
    implements NamespaceContext {
        private Map<String, String> namespaces = new HashMap<String, String>();

        public void add(String prefix, String uri) {
            Object[] props = new Object[]{prefix, uri};
            Assert.noNullElements((Object[])props, (String)"Prefix and uri parameters must not be null.");
            this.namespaces.put(prefix, uri);
        }

        public void clear() {
            this.namespaces.clear();
        }

        @Override
        public String getNamespaceURI(String prefix) {
            Assert.notNull((Object)prefix, (String)"Prefix parameter can not be null.");
            return this.namespaces.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                if (!entry.getValue().equals(namespaceURI)) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            HashSet<String> prefixes = new HashSet<String>();
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                if (!entry.getValue().equals(namespaceURI)) continue;
                prefixes.add(entry.getKey());
            }
            return prefixes.iterator();
        }
    }
}

