/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxf.transport.nmr;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.servicemix.cxf.transport.nmr.NMRConduit;
import org.apache.servicemix.cxf.transport.nmr.NMRDestination;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.ServiceMixException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NMRTransportFactory
extends AbstractTransportFactory
implements ConduitInitiator,
DestinationFactory {
    public static final String TRANSPORT_ID = "http://cxf.apache.org/transports/nmr";
    private static final Logger LOG = LogUtils.getL7dLogger(NMRTransportFactory.class);
    private NMR nmr;
    private Bus bus;
    private final Map<String, NMRDestination> destinationMap = new HashMap<String, NMRDestination>();
    private Collection<String> activationNamespaces;

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
    }

    public Bus getBus() {
        return this.bus;
    }

    public Set<String> getUriPrefixes() {
        return Collections.singleton("nmr");
    }

    @Resource
    public void setActivationNamespaces(Collection<String> ans) {
        this.activationNamespaces = ans;
    }

    public NMR getNmr() {
        return this.nmr;
    }

    public void setNmr(NMR nmr) {
        this.nmr = nmr;
    }

    @PostConstruct
    void registerWithBindingManager() {
        DestinationFactoryManager dfm;
        if (null == this.bus) {
            return;
        }
        ConduitInitiatorManager cim = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        if (null != cim && null != this.activationNamespaces) {
            for (String ns : this.activationNamespaces) {
                cim.registerConduitInitiator(ns, (ConduitInitiator)this);
            }
        }
        if (null != (dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)) && null != this.activationNamespaces) {
            for (String ns : this.activationNamespaces) {
                dfm.registerDestinationFactory(ns, (DestinationFactory)this);
            }
        }
    }

    public Conduit getConduit(EndpointInfo targetInfo) throws IOException {
        return this.getConduit(targetInfo, null);
    }

    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target) throws IOException {
        NMRConduit conduit = new NMRConduit(target, this.nmr);
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean((Object)conduit);
        }
        return conduit;
    }

    public Destination getDestination(EndpointInfo ei) throws IOException {
        NMRDestination destination = new NMRDestination(ei, this.nmr);
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean((Object)destination);
        }
        try {
            this.putDestination(ei.getService().getName().toString() + ei.getInterface().getName().toString(), destination);
        }
        catch (ServiceMixException e) {
            throw new IOException(e.getMessage());
        }
        return destination;
    }

    public void putDestination(String epName, NMRDestination destination) throws ServiceMixException {
        if (this.destinationMap.containsKey(epName)) {
            throw new ServiceMixException("JBIDestination for Endpoint " + epName + " already be created");
        }
        this.destinationMap.put(epName, destination);
    }

    public NMRDestination getDestination(String epName) {
        return this.destinationMap.get(epName);
    }

    public void removeDestination(String epName) {
        this.destinationMap.remove(epName);
    }
}

