/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.osgi.extender.internal.support.NamespacePlugins;
import org.springframework.osgi.util.OsgiBundleUtils;
import org.springframework.osgi.util.OsgiServiceUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.util.Assert;
import org.xml.sax.EntityResolver;

public class NamespaceManager
implements InitializingBean,
DisposableBean {
    private static final Log log = LogFactory.getLog((Class)NamespaceManager.class);
    private NamespacePlugins namespacePlugins;
    private ServiceRegistration nsResolverRegistration;
    private ServiceRegistration enResolverRegistration = null;
    private final BundleContext context;
    private static final String META_INF = "META-INF/";
    private static final String SPRING_HANDLERS = "spring.handlers";
    private static final String SPRING_SCHEMAS = "spring.schemas";

    public NamespaceManager(BundleContext context) {
        this.context = context;
        this.namespacePlugins = new NamespacePlugins();
    }

    public void maybeAddNamespaceHandlerFor(Bundle bundle) {
        if (OsgiBundleUtils.isSystemBundle((Bundle)bundle)) {
            return;
        }
        if (bundle.findEntries(META_INF, SPRING_HANDLERS, false) != null || bundle.findEntries(META_INF, SPRING_SCHEMAS, false) != null) {
            this.addHandler(bundle);
        }
    }

    protected void addHandler(Bundle bundle) {
        Assert.notNull((Object)bundle);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding namespace handler resolver for " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle)));
        }
        this.namespacePlugins.addHandler(bundle);
    }

    public void maybeRemoveNameSpaceHandlerFor(Bundle bundle) {
        Assert.notNull((Object)bundle);
        boolean removed = this.namespacePlugins.removeHandler(bundle);
        if (removed && log.isDebugEnabled()) {
            log.debug((Object)("Removed namespace handler resolver for " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle)));
        }
    }

    private void registerResolverServices() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Registering Spring NamespaceHandlerResolver and EntityResolver...");
        }
        this.nsResolverRegistration = this.context.registerService(new String[]{NamespaceHandlerResolver.class.getName()}, (Object)this.namespacePlugins, null);
        this.enResolverRegistration = this.context.registerService(new String[]{EntityResolver.class.getName()}, (Object)this.namespacePlugins, null);
    }

    private void unregisterResolverService() {
        boolean result = OsgiServiceUtils.unregisterService((ServiceRegistration)this.nsResolverRegistration);
        boolean bl = result = result || OsgiServiceUtils.unregisterService((ServiceRegistration)this.enResolverRegistration);
        if (result && log.isDebugEnabled()) {
            log.debug((Object)"Unregistering Spring NamespaceHandler and EntityResolver service");
        }
        this.nsResolverRegistration = null;
        this.enResolverRegistration = null;
    }

    public NamespacePlugins getNamespacePlugins() {
        return this.namespacePlugins;
    }

    public void afterPropertiesSet() {
        this.registerResolverServices();
    }

    public void destroy() {
        this.unregisterResolverService();
        this.namespacePlugins.destroy();
        this.namespacePlugins = null;
    }
}

