/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.policy.processor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.policy.builder.xml.XmlPrimitiveAssertion;
import org.apache.neethi.AbstractPolicyOperator;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.eclipse.swordfish.core.resolver.policy.PolicyDescription;
import org.eclipse.swordfish.core.resolver.policy.PolicyRole;
import org.eclipse.swordfish.core.resolver.policy.PolicyStatus;
import org.springframework.util.ReflectionUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsPolicyDescription
implements PolicyDescription<Policy> {
    private Policy policy;
    private PolicyRole policyRole;
    private PolicyStatus policyStatus;
    private DocumentFragment xml = null;

    public Policy getPolicy() {
        return this.policy;
    }

    public PolicyRole getPolicyRole() {
        return this.policyRole;
    }

    public PolicyStatus getPolicyStatus() {
        return this.policyStatus;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    public void setPolicyRole(PolicyRole policyRole) {
        this.policyRole = policyRole;
    }

    public void setPolicyStatus(PolicyStatus policyStatus) {
        this.policyStatus = policyStatus;
    }

    private void replaceXmlPrimitiveAssertionsWithWrappers(List<PolicyComponent> policyComponents) {
        ArrayList<XmlPrimitiveAssertion> listToReplace = new ArrayList<XmlPrimitiveAssertion>();
        for (PolicyComponent component : policyComponents) {
            if (component instanceof AbstractPolicyOperator) {
                this.replaceXmlPrimitiveAssertionsWithWrappers(((AbstractPolicyOperator)component).getPolicyComponents());
                continue;
            }
            if (!(component instanceof XmlPrimitiveAssertion)) continue;
            listToReplace.add((XmlPrimitiveAssertion)component);
        }
        for (XmlPrimitiveAssertion primitiveAssertion : listToReplace) {
            policyComponents.remove(primitiveAssertion);
            policyComponents.add((PolicyComponent)new XmlPrimitiveAssertionWrapper(primitiveAssertion));
        }
    }

    public DocumentFragment toXml() {
        if (this.xml == null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                XMLStreamWriter sw = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
                this.replaceXmlPrimitiveAssertionsWithWrappers(this.policy.getPolicyComponents());
                this.policy.serialize(sw);
                sw.flush();
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder db = factory.newDocumentBuilder();
                Document doc = db.parse(in);
                this.xml = doc.createDocumentFragment();
                this.xml.appendChild(doc.getFirstChild());
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            catch (FactoryConfigurationError e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.xml;
    }

    public static class XmlPrimitiveAssertionWrapper
    extends XmlPrimitiveAssertion {
        private static PolicyConstants getConstants(XmlPrimitiveAssertion assertion) {
            PolicyConstants constants = null;
            Field field = ReflectionUtils.findField(XmlPrimitiveAssertion.class, (String)"constants", PolicyConstants.class);
            field.setAccessible(true);
            try {
                constants = (PolicyConstants)field.get(assertion);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Could not access method: " + ex.getMessage());
            }
            return constants;
        }

        public XmlPrimitiveAssertionWrapper(XmlPrimitiveAssertion assertion) {
            super(assertion.getValue(), XmlPrimitiveAssertionWrapper.getConstants(assertion));
        }

        public void serialize(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeEmptyElement("swfsh", this.getValue().getLocalName(), this.getValue().getNamespaceURI());
            writer.writeNamespace("swfsh", this.getValue().getNamespaceURI());
        }
    }
}

