/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.tck.mock;

import java.net.URI;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.namespace.QName;
import org.apache.servicemix.tck.mock.MockMessageExchange;

public class MockExchangeFactory
implements MessageExchangeFactory {
    public static final URI IN_ONLY = URI.create("http://www.w3.org/2004/08/wsdl/in-only");
    public static final URI IN_OUT = URI.create("http://www.w3.org/2004/08/wsdl/in-out");
    public static final URI IN_OPTIONAL_OUT = URI.create("http://www.w3.org/2004/08/wsdl/in-opt-out");
    public static final URI ROBUST_IN_ONLY = URI.create("http://www.w3.org/2004/08/wsdl/robust-in-only");

    public MessageExchange createExchange(QName serviceName, QName operationName) throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public MessageExchange createExchange(URI pattern) throws MessagingException {
        InOnly me;
        String str = pattern.toString();
        if (str.startsWith("http://www.w3.org/2006/01/wsdl/")) {
            str = str.replace("http://www.w3.org/2006/01/wsdl/", "http://www.w3.org/2004/08/wsdl/");
            pattern = URI.create(str);
        }
        if (IN_ONLY.equals(pattern)) {
            me = this.createInOnlyExchange();
        } else if (IN_OUT.equals(pattern)) {
            me = this.createInOutExchange();
        } else if (IN_OPTIONAL_OUT.equals(pattern)) {
            me = this.createInOptionalOutExchange();
        } else if (ROBUST_IN_ONLY.equals(pattern)) {
            me = this.createRobustInOnlyExchange();
        } else {
            throw new IllegalArgumentException("Unhandled pattern: " + pattern);
        }
        ((MockMessageExchange)me).setPattern(pattern);
        return me;
    }

    public InOnly createInOnlyExchange() throws MessagingException {
        return new MockInOnly();
    }

    public InOptionalOut createInOptionalOutExchange() throws MessagingException {
        return new MockInOptionalOut();
    }

    public InOut createInOutExchange() throws MessagingException {
        return new MockInOut();
    }

    public RobustInOnly createRobustInOnlyExchange() throws MessagingException {
        return new MockRobustInOnly();
    }

    public static class MockRobustInOnly
    extends MockMessageExchange
    implements RobustInOnly {
    }

    public static class MockInOptionalOut
    extends MockMessageExchange
    implements InOptionalOut {
    }

    public static class MockInOut
    extends MockMessageExchange
    implements InOut {
    }

    public static class MockInOnly
    extends MockMessageExchange
    implements InOnly {
    }
}

