/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.p2.internal.deploy.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swordfish.p2.deploy.server.IDirector;
import org.eclipse.swordfish.p2.deploy.server.IRepositoryManager;
import org.eclipse.swordfish.p2.internal.deploy.server.IIUQueryFactory;
import org.eclipse.swordfish.p2.internal.deploy.server.IOperationSupport;
import org.eclipse.swordfish.p2.internal.deploy.server.IUQueryFactoryImpl;
import org.eclipse.swordfish.p2.internal.deploy.server.InstallableUnits;
import org.eclipse.swordfish.p2.internal.deploy.server.Messages;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.context.BundleContextAware;

public class Director
implements IDirector,
BundleContextAware {
    public static final String ID = "org.eclipse.swordfish.p2.deploy.server";
    private static final Log LOG = LogFactory.getLog(Director.class);
    private String pluginId;
    private IIUQueryFactory queryFactory;
    private IOperationSupport installSupport;
    private IOperationSupport updateSupport;
    private IOperationSupport uninstallSupport;
    private IProgressMonitor monitor;
    private IProvisioningAgent agent;
    private IRepositoryManager repoManager;
    private Configurator configurator;
    private boolean isNativeUpdate = false;

    public Director() {
        this.setMonitor((IProgressMonitor)new NullProgressMonitor());
        this.queryFactory = new IUQueryFactoryImpl();
    }

    public void deploy(MultiStatus status, InstallableUnits ius2Install, InstallableUnits ius2Update, InstallableUnits ius2Delete, InputStream repoStream, String profileId) {
        LOG.info((Object)("** deploy(" + ius2Install + "," + ius2Update + "," + ius2Delete + ", (stream)," + profileId + ")"));
        IProfile profile = this.getProfile(status, this.agent, profileId);
        ProvisioningContext provContext = null;
        if (!(!Director.proceedFurther((IStatus)status) || ius2Install.isEmpty() && ius2Update.isEmpty())) {
            provContext = this.createProvisioningContext(status, repoStream, "repo" + profile.getTimestamp());
        }
        if (Director.proceedFurther((IStatus)status) && !ius2Delete.isEmpty()) {
            this.remove(status, ius2Delete, provContext, profile);
        }
        if (Director.proceedFurther((IStatus)status) && !ius2Update.isEmpty()) {
            if (this.isNativeUpdate()) {
                this.updateNative(status, ius2Update, provContext, profile);
            } else {
                this.updateForced(status, ius2Update, provContext, profile);
            }
        }
        if (Director.proceedFurther((IStatus)status) && !ius2Install.isEmpty()) {
            this.install(status, ius2Install, provContext, profile);
        }
        if (Director.proceedFurther((IStatus)status)) {
            this.apply(status, ius2Install, ius2Update, ius2Delete);
        }
        this.logStatus("** deploy ", (IStatus)status);
    }

    public void install(MultiStatus status, InstallableUnits iuList, InputStream repoStream, String profileId) {
        LOG.info((Object)("install(" + iuList + ", (stream)," + profileId + ")"));
        IProfile profile = this.getProfile(status, this.agent, profileId);
        ProvisioningContext provContext = null;
        if (status.isOK()) {
            provContext = this.createProvisioningContext(status, repoStream, "repo" + profile.getTimestamp());
        }
        if (status.isOK()) {
            this.install(status, iuList, provContext, profile);
        }
        if (status.isOK()) {
            this.apply(status, iuList, null, null);
        }
    }

    private void install(MultiStatus status, InstallableUnits iuList, ProvisioningContext provContext, IProfile profile) {
        this.installSupport.provision(status, iuList.getUnits((IQueryable<IInstallableUnit>)provContext.getMetadata(this.monitor), this.monitor), profile, provContext, this.monitor);
    }

    public void update(MultiStatus status, InstallableUnits iuList, InputStream repoStream, String profileId) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("update(" + iuList + ", (stream)," + profileId + ")"));
        }
        IProfile profile = this.getProfile(status, this.agent, profileId);
        ProvisioningContext provContext = null;
        if (Director.proceedFurther((IStatus)status)) {
            provContext = this.createProvisioningContext(status, repoStream, "repo" + profile.getTimestamp());
        }
        if (Director.proceedFurther((IStatus)status)) {
            if (this.isNativeUpdate) {
                this.updateNative(status, iuList, provContext, profile);
            } else {
                this.updateForced(status, iuList, provContext, profile);
            }
        }
        if (Director.proceedFurther((IStatus)status)) {
            this.apply(status, null, iuList, null);
        }
        this.logStatus("update iu", (IStatus)status);
    }

    private void updateNative(MultiStatus status, InstallableUnits iuList, ProvisioningContext provContext, IProfile profile) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("updateNative(" + iuList + ", (stream)," + profile + ")"));
        }
        Collection<IInstallableUnit> existingUnits = iuList.getUnits((IQueryable<IInstallableUnit>)profile, this.monitor);
        ArrayList<IInstallableUnit> updatableUnits = new ArrayList<IInstallableUnit>();
        IQueryable queryable = provContext.getMetadata(this.monitor);
        for (IInstallableUnit existingUnit : existingUnits) {
            IQueryResult units = queryable.query(this.queryFactory.createIUQuery(existingUnit.getId()), this.monitor);
            Iterator it = units.iterator();
            while (it.hasNext()) {
                updatableUnits.add((IInstallableUnit)it.next());
            }
        }
        if (!updatableUnits.isEmpty()) {
            this.updateSupport.provision(status, updatableUnits, profile, provContext, this.monitor);
        } else {
            status.merge((IStatus)new Status(2, this.pluginId, "Nothing to update"));
        }
    }

    private void updateForced(MultiStatus status, InstallableUnits iuList, ProvisioningContext provContext, IProfile profile) {
        LOG.info((Object)("updateForced(" + iuList + ", (stream)," + profile + ")"));
        this.remove(status, iuList, provContext, profile);
        if (status.isOK()) {
            this.install(status, iuList, provContext, profile);
        }
    }

    public void remove(MultiStatus status, InstallableUnits iuList, InputStream repoStream, String profileId) {
        LOG.info((Object)("remove(" + iuList + "," + profileId + ")"));
        IProfile profile = this.getProfile(status, this.agent, profileId);
        ProvisioningContext provContext = null;
        if (status.isOK()) {
            provContext = this.createProvisioningContext(status, repoStream, "repo" + profile.getTimestamp());
        }
        if (status.isOK()) {
            this.remove(status, iuList, provContext, profile);
        }
        if (status.isOK()) {
            this.apply(status, null, null, iuList);
        }
    }

    private void remove(MultiStatus status, InstallableUnits iuList, ProvisioningContext provContext, IProfile profile) {
        this.uninstallSupport.provision(status, iuList.getUnits((IQueryable<IInstallableUnit>)profile, this.monitor), profile, provContext, this.monitor);
    }

    private void apply(MultiStatus status, InstallableUnits installed, InstallableUnits updated, InstallableUnits removed) {
        try {
            this.configurator.applyConfiguration();
            String installedIus = installed != null && !installed.isEmpty() ? installed.toString() : Messages.None;
            String updatedIus = updated != null && !updated.isEmpty() ? updated.toString() : Messages.None;
            String removedIus = removed != null && !removed.isEmpty() ? removed.toString() : Messages.None;
            String info = NLS.bind((String)Messages.Director_Apply_Sucess, (Object[])new Object[]{installedIus, updatedIus, removedIus});
            status.merge((IStatus)new Status(0, this.pluginId, info));
            this.logStatus("apply finished sucessfully", (IStatus)status);
        }
        catch (IOException e) {
            status.merge((IStatus)new Status(4, this.pluginId, Messages.Director_Apply_Failed, (Throwable)e));
        }
    }

    private ProvisioningContext createProvisioningContext(MultiStatus status, InputStream repoStream, String filePrefix) {
        ProvisioningContext provContext = null;
        try {
            provContext = this.repoManager.createProvisioningContext(filePrefix, repoStream);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to load repository", (Throwable)e);
            status.add((IStatus)new Status(4, this.pluginId, Messages.Director_Repos_Load_Failed, (Throwable)e));
        }
        return provContext;
    }

    public final void setRepositoryManager(IRepositoryManager repoManager) {
        this.repoManager = repoManager;
    }

    final IRepositoryManager getRepositoryManager() {
        return this.repoManager;
    }

    public final void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public final void setProvisioningAgent(IProvisioningAgent agent) {
        this.agent = agent;
    }

    final IProvisioningAgent getProvisioningAgent() {
        return this.agent;
    }

    public final void setInstallSupport(IOperationSupport installSupport) {
        this.installSupport = installSupport;
    }

    public final void setUpdateSupport(IOperationSupport updateSupport) {
        this.updateSupport = updateSupport;
    }

    public final void setUninstallSupport(IOperationSupport uninstallSupport) {
        this.uninstallSupport = uninstallSupport;
    }

    public final void setConfigurator(Configurator configurator) {
        this.configurator = configurator;
    }

    final Configurator getConfigurator() {
        return this.configurator;
    }

    public void setBundleContext(BundleContext ctx) {
        this.pluginId = ctx.getBundle().getSymbolicName();
    }

    final void setIUQueryFactory(IIUQueryFactory factory) {
        this.queryFactory = factory;
    }

    final boolean isNativeUpdate() {
        return this.isNativeUpdate;
    }

    public final void setNativeUpdate(boolean isNativeUpdate) {
        this.isNativeUpdate = isNativeUpdate;
    }

    private final IProfile getProfile(MultiStatus status, IProvisioningAgent agent, String id) {
        IProfile result = null;
        IProfileRegistry registry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        result = registry.getProfile(id);
        if (result == null) {
            status.merge((IStatus)new Status(4, this.pluginId, 4, NLS.bind((String)Messages.Director_Profile_NotFound, (Object)id), null));
            LOG.error((Object)("No profile with ID '" + id + "' found."));
        }
        return result;
    }

    private final void logStatus(String whichResult, IStatus st) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(String.valueOf(whichResult) + ": " + st.getCode() + " " + st.getMessage() + " (" + st.getSeverity() + ")"));
        }
    }

    public static boolean proceedFurther(IStatus status) {
        return status.isOK() || status.matches(3);
    }
}

