/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.p2.internal.deploy.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.swordfish.p2.deploy.server.IRepositoryManager;
import org.eclipse.swordfish.p2.internal.deploy.server.IMetadataProcessor;

public class RepositoryManager
implements IRepositoryManager {
    private static final Log LOG = LogFactory.getLog(RepositoryManager.class);
    private IProvisioningAgent agent;
    private IMetadataProcessor metadataProcessor;
    private IProgressMonitor monitor = new NullProgressMonitor();
    private IMetadataRepositoryManager metadataRepositoryManager;
    private IArtifactRepositoryManager artifactRepositoryManager;

    public URI load(String iuIdVersion, InputStream input) throws IOException, ProvisionException {
        LOG.info((Object)("Load " + iuIdVersion));
        this.assertAgentAndServicesAvailable();
        URI repoUri = this.createRepository(iuIdVersion, input);
        this.metadataRepositoryManager.loadRepository(repoUri, this.monitor);
        this.artifactRepositoryManager.loadRepository(repoUri, this.monitor);
        LOG.info((Object)("Loaded repository " + repoUri));
        return repoUri;
    }

    public ProvisioningContext createProvisioningContext(String iuIdVersion, InputStream input) throws IOException {
        LOG.info((Object)("CreateProvisioningContext " + iuIdVersion));
        this.assertAgentAndServicesAvailable();
        URI[] repoUri = new URI[]{this.createRepository(iuIdVersion, input)};
        ProvisioningContext provContext = new ProvisioningContext(this.agent);
        provContext.setMetadataRepositories(repoUri);
        provContext.setArtifactRepositories(repoUri);
        LOG.info((Object)("Create provisioningContext " + provContext));
        return provContext;
    }

    public URI createRepository(String iuIdVersion, InputStream input) throws IOException {
        LOG.info((Object)("CReate " + iuIdVersion));
        this.assertAgentAndServicesAvailable();
        if (input == null) {
            throw new IllegalArgumentException("Input stream must not be null!");
        }
        File repository = this.unzip(iuIdVersion, input);
        if (this.metadataProcessor != null) {
            this.metadataProcessor.updateMetaData(repository);
        }
        URI repoUri = repository.toURI();
        LOG.info((Object)("Created repository " + repoUri));
        return repoUri;
    }

    public boolean remove(URI repoUri) {
        this.assertAgentAndServicesAvailable();
        boolean removeArtifactRepo = this.artifactRepositoryManager.removeRepository(repoUri);
        LOG.debug((Object)("Removed artifact repository = " + removeArtifactRepo));
        boolean removeMetaRepo = this.metadataRepositoryManager.removeRepository(repoUri);
        LOG.debug((Object)("Removed metadata repository = " + removeMetaRepo));
        return removeMetaRepo && removeArtifactRepo;
    }

    public final void setProvisioningAgent(IProvisioningAgent agent) {
        this.agent = agent;
        if (this.agent != null) {
            this.artifactRepositoryManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
            this.metadataRepositoryManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        }
    }

    public final void setMetadataProcessor(IMetadataProcessor metadataProcessor) {
        this.metadataProcessor = metadataProcessor;
    }

    private final File unzip(String iu, InputStream repoZipStream) throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"), String.valueOf(iu) + "_" + new Random().nextInt());
        tempDir.mkdir();
        tempDir.deleteOnExit();
        ZipInputStream zin = new ZipInputStream(repoZipStream);
        ZipEntry ze = null;
        int extracted = 0;
        while ((ze = zin.getNextEntry()) != null) {
            File outFile = new File(tempDir.getCanonicalPath(), ze.getName());
            File parentDir = outFile.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            if (ze.isDirectory()) {
                if (!outFile.exists()) {
                    outFile.mkdir();
                    outFile.deleteOnExit();
                    ++extracted;
                }
            } else {
                FileOutputStream fout = new FileOutputStream(outFile);
                outFile.deleteOnExit();
                int c = zin.read();
                while (c != -1) {
                    fout.write(c);
                    c = zin.read();
                }
                fout.close();
                ++extracted;
            }
            zin.closeEntry();
        }
        zin.close();
        if (extracted == 0) {
            throw new IOException("Empty or invalid archive.");
        }
        return tempDir;
    }

    private void assertAgentAndServicesAvailable() {
        this.assertNotNull(this.agent, "provisioning agent");
        this.assertNotNull(this.metadataRepositoryManager, "metadata repository manager");
        this.assertNotNull(this.artifactRepositoryManager, "artifact repository manager");
    }

    private void assertNotNull(Object o, String name) {
        if (o == null) {
            String message = "No " + name + " available!";
            LOG.error((Object)message);
            throw new IllegalStateException(message);
        }
    }
}

