/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.p2.internal.deploy.server;

import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.p2.internal.deploy.server.ProvisioningServlet;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletActivator {
    private static final Log LOG = LogFactory.getLog(ServletActivator.class);
    private static final String LOCATION_PROPERTY = "org.eclipse.swordfish.p2.tempDirectory";
    public static final String PROVISIONING_SERLVET_ALIAS = "/p2/provisioning";
    private ProvisioningServlet provisioningServlet;
    private HttpService httpService;

    public void start() {
        LOG.info((Object)"Starting the ProvisioningServlet.");
        Hashtable<String, String> params = ServletActivator.getParams();
        try {
            this.httpService.registerServlet(PROVISIONING_SERLVET_ALIAS, (Servlet)this.provisioningServlet, params, null);
        }
        catch (ServletException e) {
            ServletActivator.throwProvisioningException("The initialization of the provisioning servlet failed.", e);
        }
        catch (NamespaceException e) {
            ServletActivator.throwProvisioningException("The LookupServlet cannot be registered under the alias /p2/provisioning because another servlet is already registered under this name", e);
        }
        LOG.info((Object)"ProvisioningServlet is active.");
    }

    public void stop() {
        LOG.info((Object)"Stopping the ProvisioningServlet.");
        this.httpService.unregister(PROVISIONING_SERLVET_ALIAS);
        LOG.info((Object)"ProvisioningServlet is stopped.");
    }

    private static Hashtable<String, String> getParams() throws IllegalStateException {
        String fileLocation = System.getProperty(LOCATION_PROPERTY, System.getProperty("java.io.tmpdir"));
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put(LOCATION_PROPERTY, fileLocation);
        return params;
    }

    private static void throwProvisioningException(String errorMessage, Throwable e) throws IllegalStateException {
        LOG.error((Object)errorMessage);
        throw new IllegalStateException(errorMessage, e);
    }

    public void setProvisioningServlet(ProvisioningServlet provisioningServlet) {
        this.provisioningServlet = provisioningServlet;
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }
}

