/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core;

import java.util.Collection;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.servicemix.nmr.api.EndpointRegistry;
import org.apache.servicemix.nmr.api.Role;
import org.apache.servicemix.nmr.api.ServiceMixException;
import org.apache.servicemix.nmr.api.internal.Flow;
import org.apache.servicemix.nmr.api.internal.FlowRegistry;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.api.internal.InternalExchange;
import org.apache.servicemix.nmr.api.internal.InternalReference;
import org.apache.servicemix.nmr.api.security.AuthorizationService;
import org.apache.servicemix.nmr.api.security.GroupPrincipal;
import org.apache.servicemix.nmr.core.ServiceRegistryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowRegistryImpl
extends ServiceRegistryImpl<Flow>
implements FlowRegistry {
    private EndpointRegistry registry;
    private AuthorizationService authorizationService;

    public EndpointRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(EndpointRegistry registry) {
        this.registry = registry;
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public boolean canDispatch(InternalExchange exchange, InternalEndpoint endpoint) {
        for (Flow flow : this.getServices()) {
            if (!flow.canDispatch(exchange, endpoint)) continue;
            return true;
        }
        return false;
    }

    public void setNonOsgiFlows(Collection<Flow> flows) {
        for (Flow f : flows) {
            this.register(f, null);
        }
    }

    public void dispatch(InternalExchange exchange) {
        if (exchange.getRole() == Role.Consumer) {
            if (exchange.getDestination() == null) {
                InternalReference target = (InternalReference)exchange.getTarget();
                assert (target != null);
                boolean match = false;
                boolean securityMatch = false;
                for (InternalEndpoint endpoint : target.choose(this.registry)) {
                    Set acls;
                    if (Boolean.valueOf((String)endpoint.getMetaData().get("UNTARGETABLE")).booleanValue()) continue;
                    match = true;
                    if (this.authorizationService != null && !(acls = this.authorizationService.getAcls(endpoint.getId(), exchange.getOperation())).contains(GroupPrincipal.ANY)) {
                        Subject subject = exchange.getIn().getSecuritySubject();
                        if (subject == null) continue;
                        acls.retainAll(subject.getPrincipals());
                        if (acls.size() == 0) continue;
                    }
                    securityMatch = true;
                    if (!this.internalDispatch(exchange, endpoint, true)) continue;
                    return;
                }
                if (!match) {
                    throw new ServiceMixException("Could not dispatch exchange. No matching endpoints.");
                }
                if (!securityMatch) {
                    throw new ServiceMixException("User not authenticated or not authorized to access any matching endpoint.");
                }
                throw new ServiceMixException("Could not dispatch exchange. No flow can handle it.");
            }
            if (!this.internalDispatch(exchange, exchange.getDestination(), false)) {
                throw new ServiceMixException("Could not dispatch exchange. No flow can handle it.");
            }
        } else if (!this.internalDispatch(exchange, exchange.getSource(), false)) {
            throw new ServiceMixException("Could not dispatch exchange. No flow can handle it.");
        }
    }

    protected boolean internalDispatch(InternalExchange exchange, InternalEndpoint endpoint, boolean setDestination) {
        for (Flow flow : this.getServices()) {
            if (!flow.canDispatch(exchange, endpoint)) continue;
            if (setDestination) {
                exchange.setDestination(endpoint);
            }
            flow.dispatch(exchange);
            return true;
        }
        return false;
    }
}

