/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.context.support;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.osgi.context.DelegatedExecutionOsgiBundleApplicationContext;
import org.springframework.osgi.context.OsgiBundleApplicationContextExecutor;
import org.springframework.osgi.context.support.AbstractOsgiBundleApplicationContext;
import org.springframework.osgi.util.OsgiBundleUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.osgi.util.internal.ClassUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractDelegatedExecutionApplicationContext
extends AbstractOsgiBundleApplicationContext
implements DelegatedExecutionOsgiBundleApplicationContext {
    private OsgiBundleApplicationContextExecutor executor = new NoDependenciesWaitRefreshExecutor(this);
    private final Object contextMonitor = new Object();
    private final Object availableMonitor = new Object();
    private boolean available = false;

    public AbstractDelegatedExecutionApplicationContext() {
    }

    public AbstractDelegatedExecutionApplicationContext(ApplicationContext parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAvailable() {
        Object object = this.availableMonitor;
        synchronized (object) {
            return this.available;
        }
    }

    public void refresh() throws BeansException, IllegalStateException {
        this.executor.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void normalRefresh() {
        Assert.notNull((Object)this.getBundleContext(), (String)"bundle context should be set before refreshing the application context");
        Thread currentThread = Thread.currentThread();
        ClassLoader oldTCCL = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this.getClassLoader());
            super.refresh();
        }
        finally {
            currentThread.setContextClassLoader(oldTCCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void normalClose() {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldTCCL = currentThread.getContextClassLoader();
        try {
            if (this.getBundleContext() != null) {
                currentThread.setContextClassLoader(this.getClassLoader());
            }
            super.doClose();
        }
        finally {
            currentThread.setContextClassLoader(oldTCCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        Object object = this.availableMonitor;
        synchronized (object) {
            this.available = false;
        }
        this.executor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRefresh() {
        if (!ClassUtils.concurrentLibAvailable()) {
            throw new IllegalStateException("JVM 5+ or backport-concurrent library (for JVM 1.4) required; see the FAQ for more details");
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldTCCL = thread.getContextClassLoader();
        try {
            Object object = this.contextMonitor;
            synchronized (object) {
                thread.setContextClassLoader(this.getClassLoader());
                if (ObjectUtils.isEmpty((Object[])this.getConfigLocations())) {
                    this.setConfigLocations(this.getDefaultConfigLocations());
                }
                if (!OsgiBundleUtils.isBundleActive(this.getBundle())) {
                    throw new ApplicationContextException("Unable to refresh application context: bundle is " + OsgiStringUtils.bundleStateAsString(this.getBundle()));
                }
                this.prepareRefresh();
                ConfigurableListableBeanFactory beanFactory = this.obtainFreshBeanFactory();
                this.prepareBeanFactory(beanFactory);
                try {
                    this.postProcessBeanFactory(beanFactory);
                    this.invokeBeanFactoryPostProcessors(beanFactory);
                    this.registerBeanPostProcessors(beanFactory);
                }
                catch (BeansException ex) {
                    beanFactory.destroySingletons();
                }
            }
        }
        catch (RuntimeException ex) {
            this.logger.error((Object)"Pre refresh error", (Throwable)ex);
            throw ex;
        }
        finally {
            thread.setContextClassLoader(oldTCCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeRefresh() {
        Thread thread = Thread.currentThread();
        ClassLoader oldTCCL = thread.getContextClassLoader();
        try {
            Object object = this.contextMonitor;
            synchronized (object) {
                thread.setContextClassLoader(this.getClassLoader());
                try {
                    ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
                    this.initMessageSource();
                    this.initApplicationEventMulticaster();
                    this.onRefresh();
                    this.registerListeners();
                    this.finishBeanFactoryInitialization(beanFactory);
                    this.finishRefresh();
                }
                catch (BeansException ex) {
                    this.getBeanFactory().destroySingletons();
                    this.logger.error((Object)"Post refresh error", (Throwable)ex);
                    throw ex;
                }
            }
        }
        finally {
            thread.setContextClassLoader(oldTCCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishRefresh() {
        super.finishRefresh();
        Object object = this.availableMonitor;
        synchronized (object) {
            this.available = true;
        }
        this.publishContextAsOsgiServiceIfNecessary();
    }

    public Object getMonitor() {
        return this.contextMonitor;
    }

    public void setExecutor(OsgiBundleApplicationContextExecutor executor) {
        this.executor = executor;
    }

    private static class NoDependenciesWaitRefreshExecutor
    implements OsgiBundleApplicationContextExecutor {
        private final DelegatedExecutionOsgiBundleApplicationContext context;

        private NoDependenciesWaitRefreshExecutor(DelegatedExecutionOsgiBundleApplicationContext ctx) {
            this.context = ctx;
        }

        public void refresh() throws BeansException, IllegalStateException {
            this.context.normalRefresh();
        }

        public void close() {
            this.context.normalClose();
        }
    }
}

