/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.internal.collection;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;

public class DynamicCollection
extends AbstractCollection {
    protected final Object iteratorsLock = new Object();
    protected final List storage;
    protected final Map iterators;

    public DynamicCollection() {
        this(16);
    }

    public DynamicCollection(int size) {
        this.storage = Collections.synchronizedList(new ArrayList(size));
        this.iterators = new WeakHashMap(4);
    }

    public DynamicCollection(Collection c) {
        this(c.size());
        this.addAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        DynamicIterator iter = new DynamicIterator();
        Object object = this.iteratorsLock;
        synchronized (object) {
            this.iterators.put(iter, null);
        }
        return iter;
    }

    public void clear() {
        this.storage.clear();
    }

    public int size() {
        return this.storage.size();
    }

    public boolean add(Object o) {
        return this.storage.add(o);
    }

    public boolean addAll(Collection c) {
        return this.storage.addAll(c);
    }

    public boolean contains(Object o) {
        return this.storage.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.storage.containsAll(c);
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        List list = this.storage;
        synchronized (list) {
            int index = this.storage.indexOf(o);
            if (index == -1) {
                return false;
            }
            this.remove(index);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object remove(int index) {
        Object o = null;
        Object object = this.iteratorsLock;
        synchronized (object) {
            o = this.storage.remove(index);
            Iterator iter = this.iterators.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                DynamicIterator dynamicIterator = (DynamicIterator)entry.getKey();
                if (index >= dynamicIterator.cursor) continue;
                --dynamicIterator.cursor;
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(int index, Object o) {
        Object object = this.iteratorsLock;
        synchronized (object) {
            this.storage.add(index, o);
            Iterator iter = this.iterators.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                DynamicIterator dynamicIterator = (DynamicIterator)entry.getKey();
                if (index >= dynamicIterator.cursor) continue;
                ++dynamicIterator.cursor;
            }
        }
    }

    public Object[] toArray() {
        return this.storage.toArray();
    }

    public Object[] toArray(Object[] array) {
        return this.storage.toArray(array);
    }

    public String toString() {
        return this.storage.toString();
    }

    protected int indexOf(Object o) {
        return this.storage.indexOf(o);
    }

    protected class DynamicIterator
    implements Iterator {
        protected volatile int cursor = 0;
        protected final Object lock = new Object();
        protected boolean removalAllowed = false;
        protected Boolean hasNext = null;

        protected DynamicIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            Object object = DynamicCollection.this.iteratorsLock;
            synchronized (object) {
                this.hasNext = this.cursor < DynamicCollection.this.storage.size() ? Boolean.TRUE : Boolean.FALSE;
            }
            return this.hasNext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public Object next() {
            this.removalAllowed = true;
            if (this.hasNext == null) {
                if (this.hasNext()) {
                    var1_1 = DynamicCollection.this.iteratorsLock;
                    synchronized (var1_1) {
                        var2_3 = DynamicCollection.this.storage.get(this.cursor++);
                        return var2_3;
                    }
                }
                throw new NoSuchElementException();
            }
            if (!this.hasNext.booleanValue()) ** break block16
            var1_2 = DynamicCollection.this.iteratorsLock;
            synchronized (var1_2) {
                if (!this.hasNext()) ** GOTO lbl23
                var2_4 = DynamicCollection.this.storage.get(this.cursor++);
                return var2_4;
                {
                    catch (Throwable var4_6) {
                        throw var4_6;
                    }
lbl23:
                    // 2 sources

                    // MONITOREXIT @DISABLED, blocks:[0, 5, 8] lbl24 : MonitorExitStatement: MONITOREXIT : var1_2
                    var1_2 = null;
                }
            }
            return var1_2;
            {
                if (!this.hasNext.booleanValue()) {
                    throw new NoSuchElementException();
                }
                throw new NoSuchElementException();
            }
            finally {
                this.hasNext = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this.removalAllowed) {
                this.removalAllowed = false;
                Object object = DynamicCollection.this.iteratorsLock;
                synchronized (object) {
                    DynamicCollection.this.remove(this.cursor - 1);
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }
}

