/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;

public class BasicWorkManager
implements WorkManager {
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public void shutDown() {
        this.executor.shutdown();
    }

    public void doWork(Work work) throws WorkException {
        work.run();
    }

    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        throw new RuntimeException("Not implemented");
    }

    public long startWork(final Work work) throws WorkException {
        final CountDownLatch latch = new CountDownLatch(1);
        this.executor.execute((Runnable)new Work(){

            public void release() {
                work.release();
            }

            public void run() {
                latch.countDown();
                work.run();
            }
        });
        long t = System.currentTimeMillis();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new WorkException("Interrupted", (Throwable)e);
        }
        return System.currentTimeMillis() - t;
    }

    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        throw new RuntimeException("Not implemented");
    }

    public void scheduleWork(Work work) throws WorkException {
        this.executor.execute((Runnable)work);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        throw new RuntimeException("Not implemented");
    }
}

