/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.jaas.modules.osgi;

import java.io.IOException;
import java.security.Principal;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.servicemix.kernel.jaas.modules.RolePrincipal;
import org.apache.servicemix.kernel.jaas.modules.UserPrincipal;
import org.apache.servicemix.kernel.jaas.modules.osgi.ConfigAdminHolder;
import org.osgi.service.cm.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiConfigLoginModule
implements LoginModule {
    public static final String PID = "pid";
    public static final String USER_PREFIX = "user.";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> options;
    private Set<Principal> principals;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
    }

    @Override
    public boolean login() throws LoginException {
        try {
            String userInfos;
            String pid = (String)this.options.get(PID);
            Configuration config = ConfigAdminHolder.getService().getConfiguration(pid);
            Dictionary properties = config.getProperties();
            Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (IOException ioe) {
                throw new LoginException(ioe.getMessage());
            }
            catch (UnsupportedCallbackException uce) {
                throw new LoginException(uce.getMessage() + " not available to obtain information from user");
            }
            String user = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            if ((userInfos = (String)properties.get(USER_PREFIX + user)) == null) {
                throw new FailedLoginException("User does not exist");
            }
            String[] infos = userInfos.split(",");
            if (!new String(tmpPassword).equals(infos[0])) {
                throw new FailedLoginException("Password does not match");
            }
            this.principals = new HashSet<Principal>();
            this.principals.add(new UserPrincipal(user));
            for (int i = 1; i < infos.length; ++i) {
                this.principals.add(new RolePrincipal(infos[i]));
            }
            boolean bl = true;
            return bl;
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Exception e) {
            throw (LoginException)new LoginException("Unable to authenticate user").initCause(e);
        }
        finally {
            this.callbackHandler = null;
            this.options = null;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        this.subject.getPrincipals().addAll(this.principals);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.subject = null;
        this.principals = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean logout() throws LoginException {
        try {
            this.subject.getPrincipals().removeAll(this.principals);
            this.principals.clear();
            boolean bl = true;
            return bl;
        }
        finally {
            this.subject = null;
            this.principals = null;
        }
    }
}

