/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.event;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.swordfish.core.event.Event;
import org.eclipse.swordfish.internal.core.event.EventHandlerAdapter;
import org.eclipse.swordfish.internal.core.util.RegistryImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventHandler;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventHandlerRegistry<T extends Event>
extends RegistryImpl<org.eclipse.swordfish.core.event.EventHandler<T>>
implements BundleContextAware {
    private BundleContext bundleContext;
    protected ConcurrentHashMap<org.eclipse.swordfish.core.event.EventHandler<T>, ServiceRegistration> registrations = new ConcurrentHashMap();

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected void doRegister(org.eclipse.swordfish.core.event.EventHandler<T> handler, Map<String, ?> properties) throws Exception {
        Assert.notNull(handler);
        this.LOG.info((Object)("Registering event listener for [" + handler.getSubscribedTopic() + "] topic"));
        Assert.notNull((Object)handler.getSubscribedTopic());
        Dictionary<String, Object> props = this.getEventHandlerProperties(handler);
        EventHandlerAdapter<T> eventHandlerAdapder = new EventHandlerAdapter<T>(handler);
        this.registrations.put(handler, this.bundleContext.registerService(EventHandler.class.getName(), eventHandlerAdapder, props));
        super.doRegister(handler, properties);
    }

    protected void doUnregister(org.eclipse.swordfish.core.event.EventHandler<T> key, Map<String, ?> properties) throws Exception {
        ServiceRegistration serviceRegistration = this.registrations.get(key);
        Assert.notNull((Object)serviceRegistration, (String)("serviceRegistration for the event listener with topic = [" + key.getSubscribedTopic() + "] can not be found"));
        serviceRegistration.unregister();
        super.doUnregister(key, properties);
    }

    protected void doDestroy() throws Exception {
        for (ServiceRegistration registration : this.registrations.values()) {
            registration.unregister();
        }
        super.doDestroy();
    }

    protected Dictionary<String, Object> getEventHandlerProperties(org.eclipse.swordfish.core.event.EventHandler<T> handler) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("event.topics", handler.getSubscribedTopic());
        if (handler.getEventFilter() != null) {
            ((Dictionary)props).put("event.filter", handler.getEventFilter().getExpression());
        }
        return props;
    }
}

