/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.backend.base.wsdl11;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.resolver.policy.PolicyDefinitionDescription;
import org.eclipse.swordfish.core.resolver.registry.ServiceDescription;
import org.eclipse.swordfish.internal.resolver.backend.base.wsdl.SwordfishPort;
import org.eclipse.swordfish.internal.resolver.backend.base.wsdl.SwordfishPortImpl;
import org.eclipse.swordfish.internal.resolver.backend.base.wsdl.Transport;
import org.eclipse.swordfish.internal.resolver.backend.base.wsdl11.WSDL11EmbeddedPolicyDefinitionDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL11ServiceDescription
implements ServiceDescription<Definition> {
    private static final Log LOG = LogFactory.getLog(WSDL11ServiceDescription.class);
    private Definition wsdl;
    private PortType portType;
    private Service service;
    private Map<String, Operation> operations = null;
    private boolean populated;
    private Map<ExtensibilityElement, ExtensibilityElement> availableLocations;
    private Map<String, PolicyDefinitionDescription> policyDefinitions = null;

    public WSDL11ServiceDescription(Definition wsdl) {
        if (wsdl == null) {
            throw new IllegalArgumentException("Definition could not be null.");
        }
        this.wsdl = wsdl;
        try {
            this.populate();
        }
        catch (Exception e) {
            LOG.error((Object)"Couldn't initialize service description, nested exception is: ", (Throwable)e);
            throw new IllegalStateException("Couldn't initialize service description, nested exception is: ", e);
        }
    }

    private void populate() {
        if (this.populated) {
            return;
        }
        Map portTypes = this.wsdl.getPortTypes();
        if (portTypes.size() == 0) {
            throw new IllegalStateException("No port types were found.");
        }
        this.portType = (PortType)portTypes.values().iterator().next();
        Map services = this.wsdl.getServices();
        if (services.size() == 0) {
            throw new IllegalStateException("No services were found.");
        }
        this.service = (Service)services.values().iterator().next();
        this.operations = new HashMap<String, Operation>();
        HashSet<String> declaredOperationNames = new HashSet<String>();
        for (Object port : this.service.getPorts().values()) {
            Binding portBinding = ((Port)Port.class.cast(port)).getBinding();
            for (Object bop : portBinding.getBindingOperations()) {
                declaredOperationNames.add(((BindingOperation)BindingOperation.class.cast(bop)).getName());
            }
        }
        for (String opName : declaredOperationNames) {
            Operation op = this.portType.getOperation(opName, null, null);
            if (op == null) continue;
            this.operations.put(op.getName(), op);
        }
        this.populated = true;
    }

    public synchronized Map<ExtensibilityElement, ExtensibilityElement> getAvailableLocations() {
        if (this.availableLocations != null) {
            return this.availableLocations;
        }
        this.availableLocations = new HashMap<ExtensibilityElement, ExtensibilityElement>();
        try {
            for (Object portObj : this.service.getPorts().values()) {
                Port port = (Port)portObj;
                ExtensibilityElement address = null;
                for (Object soapAddr : port.getExtensibilityElements()) {
                    if (!(soapAddr instanceof SOAPAddress) && !(soapAddr instanceof SOAP12Address)) continue;
                    address = (ExtensibilityElement)soapAddr;
                    break;
                }
                ExtensibilityElement soapBinding = null;
                if (address != null) {
                    for (Object soapBindObj : port.getBinding().getExtensibilityElements()) {
                        if (!(soapBindObj instanceof SOAPBinding) && !(soapBindObj instanceof SOAP12Binding)) continue;
                        soapBinding = (ExtensibilityElement)soapBindObj;
                        break;
                    }
                }
                if (address == null || soapBinding == null) continue;
                this.availableLocations.put(address, soapBinding);
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Ignoring the exception and returning null", (Throwable)ex);
        }
        return this.availableLocations;
    }

    public String getPortName(String address, String transportURI) {
        String portName = null;
        try {
            for (Object portObj : this.service.getPorts().values()) {
                Port port = (Port)portObj;
                for (Object soapAddr : port.getExtensibilityElements()) {
                    if ((!(soapAddr instanceof SOAPAddress) || !address.equalsIgnoreCase(((SOAPAddress)soapAddr).getLocationURI())) && (!(soapAddr instanceof SOAP12Address) || !address.equalsIgnoreCase(((SOAP12Address)soapAddr).getLocationURI()))) continue;
                    for (Object soapBindObj : port.getBinding().getExtensibilityElements()) {
                        if ((!(soapBindObj instanceof SOAPBinding) || !transportURI.equalsIgnoreCase(((SOAPBinding)soapBindObj).getTransportURI())) && (!(soapBindObj instanceof SOAP12Binding) || !transportURI.equalsIgnoreCase(((SOAP12Binding)soapBindObj).getTransportURI()))) continue;
                        portName = port.getName();
                        return portName;
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Ignoring the exception and returning null", (Throwable)ex);
        }
        return null;
    }

    public Class<Definition> getType() {
        return Definition.class;
    }

    public QName getServiceName() {
        return this.service.getQName();
    }

    public QName getPortTypeName() {
        return this.portType.getQName();
    }

    public Collection<Operation> getOperations() {
        return this.operations.values();
    }

    public Operation getOperation(String operationName) {
        return this.operations.get(operationName);
    }

    public Part getOperationInputMessagePart(String operationName) {
        Part part = null;
        Operation operation = this.portType.getOperation(operationName, null, null);
        if (operation != null) {
            Map operationParts = operation.getInput().getMessage().getParts();
            part = (Part)Part.class.cast(operationParts.values().iterator().next());
        }
        return part;
    }

    public Part getOperationOutputMessagePart(String operationName) {
        Part part = null;
        Operation operation = this.portType.getOperation(operationName, null, null);
        if (operation != null) {
            Map operationParts = operation.getOutput().getMessage().getParts();
            part = (Part)Part.class.cast(operationParts.values().iterator().next());
        }
        return part;
    }

    public Map<String, PolicyDefinitionDescription> getEmbeddedPolicyDefinitions() {
        if (this.policyDefinitions == null) {
            this.policyDefinitions = this.createEmbeddedPolicyDefinitions();
        }
        return this.policyDefinitions;
    }

    private Map<String, PolicyDefinitionDescription> createEmbeddedPolicyDefinitions() {
        HashMap<String, PolicyDefinitionDescription> result = new HashMap<String, PolicyDefinitionDescription>();
        for (Map.Entry e : this.service.getPorts().entrySet()) {
            String portName = (String)e.getKey();
            Port port = (Port)e.getValue();
            Binding binding = port.getBinding();
            List ee = binding.getExtensibilityElements();
            for (ExtensibilityElement element : ee) {
                if (!WSDL11EmbeddedPolicyDefinitionDescription.POLICY_ELEMENT.equals(element.getElementType())) continue;
                WSDL11EmbeddedPolicyDefinitionDescription pd = new WSDL11EmbeddedPolicyDefinitionDescription(this.service.getQName(), portName, (UnknownExtensibilityElement)element);
                result.put(portName, (PolicyDefinitionDescription)pd);
            }
        }
        return result;
    }

    public SwordfishPort getPort(String wsdlPortName) {
        SwordfishPortImpl SwordfishPort2 = null;
        Port port = this.service.getPort(wsdlPortName);
        if (port != null) {
            SwordfishPort2 = new SwordfishPortImpl(port);
        }
        return SwordfishPort2;
    }

    public SwordfishPortImpl[] getSupportedPorts(String operationName) {
        ArrayList<SwordfishPortImpl> list = new ArrayList<SwordfishPortImpl>();
        for (Port port : this.service.getPorts().values()) {
            Binding binding = port.getBinding();
            for (BindingOperation bop : binding.getBindingOperations()) {
                if (!bop.getName().equals(operationName)) continue;
                list.add(new SwordfishPortImpl(port));
            }
        }
        return list.toArray(new SwordfishPortImpl[list.size()]);
    }

    public SwordfishPort[] getPorts() {
        ArrayList<SwordfishPortImpl> list = new ArrayList<SwordfishPortImpl>();
        for (Port port : this.service.getPorts().values()) {
            list.add(new SwordfishPortImpl(port));
        }
        return list.toArray(new SwordfishPortImpl[list.size()]);
    }

    public SwordfishPort choosePort(String operationName, String defaultTransport) {
        SwordfishPortImpl[] ports = this.getSupportedPorts(operationName);
        HashMap<Transport, SwordfishPortImpl> usablePorts = new HashMap<Transport, SwordfishPortImpl>();
        int i = 0;
        while (i < ports.length) {
            usablePorts.put(ports[i].getTransport(), ports[i]);
            ++i;
        }
        if (usablePorts.size() == 1) {
            return (SwordfishPort)usablePorts.values().iterator().next();
        }
        if (usablePorts.size() > 1) {
            SwordfishPort port = (SwordfishPort)usablePorts.get((Object)Transport.fromString(defaultTransport));
            if (port != null) {
                return port;
            }
            throw new RuntimeException("Cannot decide which transport to use: The service description and the agreed policy allow for more than one transport to be used but none of them matches the default transport defined in the configuration.");
        }
        throw new RuntimeException("No ports are defined in the service provider description for " + this.getServiceName().toString());
    }
}

