/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.plugins.tracking;

import javax.jbi.messaging.MessageExchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.event.EventConstants;
import org.eclipse.swordfish.core.event.EventFilter;
import org.eclipse.swordfish.core.event.EventHandler;
import org.eclipse.swordfish.core.event.TrackingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackingEventHandler
implements EventHandler<TrackingEvent> {
    private static final Log LOG = LogFactory.getLog(TrackingEventHandler.class);

    public EventFilter getEventFilter() {
        return null;
    }

    public String getSubscribedTopic() {
        return EventConstants.TOPIC_TRACKING_EVENT;
    }

    public void handleEvent(TrackingEvent event) {
        MessageExchange exchange = event.getExchange();
        String messageType = exchange.getRole().equals(MessageExchange.Role.CONSUMER) ? "Outgoing" : "Incoming";
        String output = String.format("%s event with id=[%s]", messageType, exchange.getExchangeId());
        if (exchange.getMessage("in") != null) {
            output = String.valueOf(output) + "\n    in message : " + exchange.getMessage("in").getContent().toString();
        }
        if (exchange.getMessage("out") != null && exchange.getMessage("out").getContent() != null) {
            output = String.valueOf(output) + "\n    out message : " + exchange.getMessage("out").getContent().toString();
        }
        if (exchange.getError() != null) {
            output = String.valueOf(output) + "\n    exception class   : " + exchange.getError().getClass().getCanonicalName();
            output = String.valueOf(output) + "\n    exception message : " + exchange.getError().getMessage();
        }
        LOG.debug((Object)output);
    }
}

