/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.registry;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.swordfish.registry.DefaultResource;
import org.eclipse.swordfish.registry.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSILResource
extends DefaultResource
implements Resource {
    public static final String PREFIX = "<?xml version=\"1.0\"?>\n<inspection xmlns=\"http://schemas.xmlsoap.org/ws/2001/10/inspection/\">\n";
    public static final String ITEM_PREFIX = "  <service>\n";
    public static final String ITEM_DESC_PREFIX = "    <description referencedNamespace=\"http://schemas.xmlsoap.org/wsdl/\"\n                 location=\"";
    public static final String ITEM_DESC_POSTFIX = "\"/>\n";
    public static final String ITEM_NAME_PREFIX = "    <name>";
    public static final String ITEM_NAME_POSTFIX = "</name>\n";
    public static final String ITEM_POSTFIX = "  </service>\n";
    public static final String POSTFIX = "</inspection>";
    private String wsdlBaseUrl;
    private Iterable<String> identifiers;

    public WSILResource(String baseUrl, Iterable<String> identifiers) {
        this.wsdlBaseUrl = String.valueOf(baseUrl) + "/wsdl";
        this.identifiers = identifiers;
    }

    @Override
    public void get(Writer writer) throws IOException {
        writer.append(PREFIX);
        for (String identifier : this.identifiers) {
            writer.append(ITEM_PREFIX);
            writer.append(ITEM_NAME_PREFIX).append(identifier).append(ITEM_NAME_POSTFIX);
            writer.append(ITEM_DESC_PREFIX);
            writer.append(String.valueOf(this.wsdlBaseUrl) + "/" + identifier);
            writer.append(ITEM_DESC_POSTFIX);
            writer.append(ITEM_POSTFIX);
        }
        writer.append(POSTFIX);
    }

    @Override
    public void appendContent(Writer writer) throws IOException {
        this.get(writer);
    }

    @Override
    public String getId() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    @Override
    public String getCharacterEncoding() {
        return "UTF-8";
    }
}

