/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.samples.cxf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebParam;
import javax.jws.WebService;
import org.eclipse.swordfish.samples.cxf.BookingService;
import org.eclipse.swordfish.samples.cxf.domain.Flight;
import org.eclipse.swordfish.samples.cxf.domain.Passenger;
import org.eclipse.swordfish.samples.cxf.domain.Reservation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(endpointInterface="org.eclipse.swordfish.samples.cxf.BookingService", serviceName="BookingServiceImpl")
public class BookingServiceImpl
implements BookingService {
    private static int passengerId;
    private static int flightId;
    private static int bookingId;
    private static Map<Integer, Reservation> reservationStorage;

    static {
        reservationStorage = new HashMap<Integer, Reservation>();
    }

    @Override
    public int createReservation(@WebParam(name="passengers") List<Passenger> passengers, @WebParam(name="flight") Flight flight) {
        if (flight == null) {
            throw new IllegalArgumentException("The supplied flight is null");
        }
        int reservationId = ++bookingId;
        Reservation reservation = new Reservation();
        reservation.setId(reservationId);
        reservation.setFlight(flight);
        reservation.setPassengers(passengers);
        reservationStorage.put(reservationId, reservation);
        return reservationId;
    }

    @Override
    public Reservation findReservation(int reservationId) {
        return reservationStorage.get(reservationId);
    }

    @Override
    public Integer getReservationQuantity() {
        return null;
    }
}

