/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.samples.jaxws.reservation;

import java.util.Arrays;
import java.util.List;
import javax.jws.WebParam;
import javax.jws.WebService;
import org.eclipse.swordfish.samples.jaxws.domain.Flight;
import org.eclipse.swordfish.samples.jaxws.domain.Passenger;
import org.eclipse.swordfish.samples.jaxws.domain.Reservation;
import org.eclipse.swordfish.samples.jaxws.reservation.ReservationService;
import org.eclipse.swordfish.samples.jaxws.storage.ReservationStorageServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(endpointInterface="org.eclipse.swordfish.samples.jaxws.reservation.ReservationService", serviceName="ReservationService")
public class ReservationServiceImpl
implements ReservationService {
    @Override
    public int createReservation(@WebParam(name="passengers") List<Passenger> passengers, @WebParam(name="flight") Flight flight) {
        if (flight == null) {
            throw new IllegalArgumentException("The supplied flight is null");
        }
        Reservation reservation = new Reservation();
        reservation.setFlight(flight);
        reservation.setPassengers(passengers);
        int reservationId = ReservationStorageServiceHelper.httpAddReservation(reservation);
        return reservationId;
    }

    public static void main(String[] arg) {
        Reservation reservation = new Reservation();
        reservation.setPassengers(Arrays.asList(new Passenger(1, "Elena", "Krytelova", 24)));
        reservation.setFlight(new Flight(1, "LC023"));
        int reservationId = ReservationStorageServiceHelper.httpAddReservation(reservation);
        System.out.println(reservationId);
    }
}

