/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.samples.jaxws.storage;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.eclipse.swordfish.samples.jaxws.domain.Passenger;
import org.eclipse.swordfish.samples.jaxws.domain.Reservation;
import org.eclipse.swordfish.samples.jaxws.storage.ReservationStorageService;

public class ReservationStorageServiceHelper {
    public static final String url = "http://localhost:8194/storage/";
    private static final String REQUEST_BODY_START = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:wsa=\"http://www.w3.org/2005/08/addressing\"> <soap:Header></soap:Header><soap:Body><ns2:addReservation xmlns:ns2=\"http://storage.jaxws.samples.swordfish.eclipse\"><reservation>";
    private static final String REQUEST_PASSENGERS = "<passengers><age>%s</age><firstName>%s</firstName><id>%s</id><lastName>%s</lastName></passengers>";
    private static final String REQUEST_FLIGHT = "<flight><flightNumber>%s</flightNumber><id>%s</id></flight>";
    private static final String REQUEST_BODY_END = "</reservation></ns2:addReservation></soap:Body></soap:Envelope>";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int httpAddReservation(Reservation reservation) {
        Passenger passenger = reservation.getPassengers().get(0);
        String passengers = String.format(REQUEST_PASSENGERS, passenger.getAge(), passenger.getFirstName(), passenger.getId(), passenger.getLastName());
        String flight = String.format(REQUEST_FLIGHT, reservation.getFlight().getFlightNumber(), reservation.getFlight().getId());
        String REQUEST_BODY = REQUEST_BODY_START + passengers + flight + REQUEST_BODY_END;
        try {
            PostMethod post = new PostMethod(url);
            StringRequestEntity entity = new StringRequestEntity(REQUEST_BODY, "text/xml", "UTF8");
            post.setRequestEntity((RequestEntity)entity);
            post.setRequestHeader("SOAPAction", "");
            HttpClient httpclient = new HttpClient();
            try {
                int result = httpclient.executeMethod((HttpMethod)post);
                if (result == 200) {
                    String response = post.getResponseBodyAsString();
                    Pattern p = Pattern.compile("<return>(.*)</return>");
                    Matcher m = p.matcher(response);
                    m.find();
                    String reservationId = m.group(1);
                    int n = Integer.parseInt(reservationId);
                    return n;
                }
                System.out.println();
                return 0;
            }
            finally {
                post.releaseConnection();
            }
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    public static ReservationStorageService getService() {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(ReservationStorageService.class);
        factory.setAddress(url);
        return (ReservationStorageService)factory.create();
    }
}

