/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.tooling.ode.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swordfish.tooling.ode.ui.OdeArtifactsHolder;

public class OdeArtifactsVisitor
implements IResourceVisitor {
    private final OdeArtifactsHolder artifactsHolder;
    private boolean odeResourcesChanged = false;
    private boolean deployXmlChanged = false;

    public boolean visit(IResource resource) throws CoreException {
        if (resource.getProjectRelativePath().toString().startsWith("bin")) {
            return false;
        }
        if (!resource.getProjectRelativePath().toString().startsWith("src")) {
            return true;
        }
        if (resource.getProjectRelativePath().toString().toLowerCase().endsWith("deploy.xml")) {
            this.artifactsHolder.setDeployXml(resource);
            this.deployXmlChanged = true;
        } else if (resource.getProjectRelativePath().toString().toLowerCase().endsWith(".bpel")) {
            this.artifactsHolder.getBpelFiles().add(resource);
        } else if (resource.getProjectRelativePath().toString().toLowerCase().endsWith(".wsdl")) {
            this.artifactsHolder.getWsdl().add(resource);
        } else {
            return true;
        }
        this.odeResourcesChanged = true;
        return false;
    }

    public OdeArtifactsHolder getArtifactsHolder() {
        return this.artifactsHolder;
    }

    public boolean isOdeResourcesChanged() {
        return this.odeResourcesChanged;
    }

    public boolean isDeployXmlChanged() {
        return this.deployXmlChanged;
    }

    public OdeArtifactsVisitor(OdeArtifactsHolder artifactsHolder) {
        this.artifactsHolder = artifactsHolder;
    }
}

