/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.tooling.ode.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swordfish.tooling.ode.ui.OdeArtifactsHolder;
import org.eclipse.swordfish.tooling.ode.ui.util.BpelSupport;
import org.eclipse.swordfish.tooling.ode.ui.util.HttpEndpointInfo;
import org.eclipse.swordfish.tooling.ui.helper.FileUtil;
import org.eclipse.swordfish.tooling.ui.helper.WsdlSupport;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdeConfigurationBuilder {
    public static List<HttpEndpointInfo> retriveHttpEndpointsInfo(OdeArtifactsHolder artifactsHolder) {
        Assert.isTrue((boolean)artifactsHolder.isEligibleForBuild());
        ArrayList<File> bpelProcesses = new ArrayList<File>();
        for (IResource bpel : artifactsHolder.getBpelFiles()) {
            bpelProcesses.add(FileUtil.toFile((IResource)bpel));
        }
        return OdeConfigurationBuilder.retriveHttpEndpointsInfo(FileUtil.toFile((IResource)artifactsHolder.getDeployXml()), new ArrayList<IResource>(artifactsHolder.getBpelFiles()), new ArrayList<IResource>(artifactsHolder.getWsdl()));
    }

    public static List<HttpEndpointInfo> retriveHttpEndpointsInfo(File deployXml, List<IResource> bpelProcesses, List<IResource> wsdlResources) {
        ArrayList<HttpEndpointInfo> ret = new ArrayList<HttpEndpointInfo>();
        for (BpelSupport.PartnerLinkInfo linkInfo : OdeConfigurationBuilder.getPartnerLinks(deployXml)) {
            try {
                Map<Document, String> wsdls = OdeConfigurationBuilder.getWsdls(bpelProcesses, wsdlResources);
                Document wsdl = OdeConfigurationBuilder.findApropriateWsdl(wsdls.keySet(), linkInfo);
                String serviceUrl = WsdlSupport.getServiceUrl((Document)wsdl);
                if (serviceUrl == null) {
                    throw new IllegalStateException("No service URL present in the wsdl for " + linkInfo);
                }
                String location = wsdls.get(wsdl);
                if (!location.contains("/") && !location.contains("\\")) {
                    location = "osgibundle:/" + location;
                }
                ret.add(HttpEndpointInfo.valueOf(linkInfo, serviceUrl, location));
            }
            catch (Exception ex) {
                HttpEndpointInfo errorEndpoint = new HttpEndpointInfo();
                errorEndpoint.setError(ex);
                ret.add(errorEndpoint);
            }
        }
        return ret;
    }

    public static List<BpelSupport.PartnerLinkInfo> getPartnerLinks(File deployXml) {
        return BpelSupport.retrievePartnerLinksFromDeployXml(deployXml);
    }

    public static Map<Document, String> getWsdls(List<IResource> bpelProcesses, List<IResource> wsdls) {
        HashMap<Document, String> ret = new HashMap<Document, String>();
        InputStream inputStream = null;
        for (IResource bpel : bpelProcesses) {
            List<String> locations = BpelSupport.retriveWsdlLocationsFromBpelFile(FileUtil.toFile((IResource)bpel));
            for (String location : locations) {
                try {
                    try {
                        if (location.toLowerCase().startsWith("http")) {
                            URL url = new URL(location);
                            inputStream = url.openStream();
                            ret.put(DOMUtils.readXml((InputStream)inputStream), location);
                        } else if (!location.contains("/") && !location.contains("\\") && new File(FileUtil.toFile((IResource)bpel).getParent(), location).exists()) {
                            File wsdlFile = new File(FileUtil.toFile((IResource)bpel).getParent(), location);
                            inputStream = new FileInputStream(wsdlFile);
                            String dir = bpel.getProjectRelativePath().toString();
                            Assert.isTrue((boolean)dir.startsWith("src"));
                            dir = dir.substring("src".length());
                            dir = dir.substring(0, dir.lastIndexOf(bpel.getName()));
                            ret.put(DOMUtils.readXml((InputStream)inputStream), "classpath:" + dir + location);
                        } else {
                            int index = location.lastIndexOf("/");
                            if (index < 0) {
                                index = location.lastIndexOf("\\");
                            }
                            IResource found = null;
                            String filename = location;
                            if (index >= 0) {
                                filename = location.substring(index);
                            }
                            for (IResource wsdl : wsdls) {
                                if (!filename.equalsIgnoreCase(wsdl.getName())) continue;
                                found = wsdl;
                                break;
                            }
                            if (found != null) {
                                String dir = found.getProjectRelativePath().toString();
                                dir = dir.substring("src".length());
                                File wsdlFile = FileUtil.toFile((IResource)found);
                                inputStream = new FileInputStream(wsdlFile);
                                ret.put(DOMUtils.readXml((InputStream)inputStream), "classpath:" + dir);
                            } else if (new File(location).exists()) {
                                ret.put(DOMUtils.readXml((InputStream)new FileInputStream(new File(location))), location);
                            } else {
                                System.out.println("Couldn't find wsdl for location : " + location);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (inputStream == null) continue;
                        try {
                            inputStream.close();
                            continue;
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    throw throwable;
                }
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return ret;
    }

    private static Document findApropriateWsdl(Collection<Document> wsdls, BpelSupport.PartnerLinkInfo linkInfo) {
        ArrayList<Document> found = new ArrayList<Document>();
        for (Document wsdl : wsdls) {
            if (linkInfo.serviceName == null || !linkInfo.serviceName.getLocalPart().equalsIgnoreCase(WsdlSupport.getServiceName((Document)wsdl))) continue;
            found.add(wsdl);
        }
        if (found.isEmpty()) {
            throw new IllegalStateException("Could not find wsdl file with serviceName " + linkInfo.serviceName.getLocalPart());
        }
        if (found.size() == 1) {
            return (Document)found.get(0);
        }
        for (Document wsdl : wsdls) {
            if (!WsdlSupport.getPortName((Document)wsdl).equalsIgnoreCase(linkInfo.portName)) continue;
            found.add(wsdl);
        }
        if (found.isEmpty()) {
            throw new IllegalStateException("Could not find wsdl file with portName " + linkInfo.portName);
        }
        if (found.size() == 1) {
            return (Document)found.get(0);
        }
        for (Document wsdl : wsdls) {
            if (!WsdlSupport.getTargetNameSpace((Document)wsdl).equalsIgnoreCase(linkInfo.serviceName.getNamespaceURI())) continue;
            found.add(wsdl);
        }
        if (found.isEmpty()) {
            throw new IllegalStateException("Could not find wsdl file with targetNameSpace " + linkInfo.serviceName.getNamespaceURI());
        }
        return (Document)found.get(0);
    }

    public static String buildServiceNameSpaces(List<HttpEndpointInfo> endpoints) {
        StringBuilder ret = new StringBuilder();
        int i = 0;
        ArrayList<String> usedPrefixes = new ArrayList<String>(endpoints.size());
        String prefix = null;
        for (HttpEndpointInfo endpointInfo : endpoints) {
            if (endpointInfo.getError() != null) continue;
            Assert.isNotNull((Object)endpointInfo.getServiceName());
            prefix = endpointInfo.getServiceName().getPrefix() != null ? endpointInfo.getServiceName().getPrefix() : "serviceNameSpace" + ++i;
            if (usedPrefixes.contains(prefix)) {
                prefix = String.valueOf(prefix) + ++i;
            }
            ret.append("       xmlns:").append(prefix).append("=\"").append(endpointInfo.getServiceName().getNamespaceURI()).append("\"\n");
            usedPrefixes.add(prefix);
            endpointInfo.setServiceName(new QName(endpointInfo.getServiceName().getNamespaceURI(), endpointInfo.getServiceName().getLocalPart(), prefix));
        }
        return ret.toString();
    }
}

