/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.tooling.ode.ui.extension;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swordfish.tooling.ode.ui.OdeArtifactsHolder;
import org.eclipse.swordfish.tooling.ode.ui.OdeArtifactsVisitor;
import org.eclipse.swordfish.tooling.ode.ui.OdeConfigurationBuilder;
import org.eclipse.swordfish.tooling.ode.ui.util.HttpEndpointInfo;
import org.eclipse.swordfish.tooling.ui.helper.FileUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OdeArtifactsProjectBuilder
extends IncrementalProjectBuilder {
    private static final String HTTP_ENDPOINTS_FILENAME = "META-INF/spring/http-endpoints.xml";
    private static final String HTTP_ENDPOINTS_TEMPLATE = "/templates/ode/http-endpoints.xml";
    private static final String BPEL_EXPORTER_FILENAME = "META-INF/spring/bpel-exporter.xml";
    private static final String BPEL_EXPORTER_TEMPLATE = "/templates/ode/bpel-exporter.xml";
    private PreferenceStore preferenceStore = new PreferenceStore();
    private Set<HttpEndpointInfo> existingHttpEndpoints = new HashSet<HttpEndpointInfo>();
    private String deployXmlPath = null;
    public static final String SRC_FOLDER = "src";

    private synchronized OdeArtifactsHolder createOdeArtifactsHolder() throws CoreException {
        OdeArtifactsHolder artifactsHolder = new OdeArtifactsHolder();
        OdeArtifactsVisitor visitor = new OdeArtifactsVisitor(artifactsHolder);
        this.getProject().accept((IResourceVisitor)visitor);
        return artifactsHolder;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    private void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        System.out.println("incremental build on " + delta);
        final OdeArtifactsVisitor visitor = new OdeArtifactsVisitor(new OdeArtifactsHolder());
        delta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                System.out.println("changed: " + delta.getResource().getProjectRelativePath());
                return visitor.visit(delta.getResource());
            }
        });
        if (visitor.isOdeResourcesChanged()) {
            this.fullBuild(monitor);
        }
    }

    private void performBuild(IProgressMonitor monitor, OdeArtifactsHolder artifactsHolder) throws CoreException {
        List<HttpEndpointInfo> httpEndpoints;
        if (!artifactsHolder.isEligibleForBuild()) {
            return;
        }
        String newDeployXmlPath = this.retriveProjectRelativePath(artifactsHolder.getDeployXml());
        if (this.deployXmlPath == null || !this.deployXmlPath.equals(newDeployXmlPath)) {
            HashMap<String, String> templateSubstitution = new HashMap<String, String>(1);
            templateSubstitution.put("deployXmlPath", newDeployXmlPath);
            try {
                FileUtil.createFileFromTemplate((IProgressMonitor)monitor, (IProject)this.getProject(), (String)BPEL_EXPORTER_FILENAME, (InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(BPEL_EXPORTER_TEMPLATE), templateSubstitution);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.deployXmlPath = newDeployXmlPath;
        }
        if ((httpEndpoints = OdeConfigurationBuilder.retriveHttpEndpointsInfo(artifactsHolder)).size() == 0 && this.existingHttpEndpoints.size() == httpEndpoints.size() && this.existingHttpEndpoints.containsAll(httpEndpoints)) {
            System.out.println("Not changes were performed");
            return;
        }
        ArrayList<Throwable> warnings = new ArrayList<Throwable>();
        this.existingHttpEndpoints = new HashSet<HttpEndpointInfo>(httpEndpoints);
        StringBuilder httpEndpointConfig = new StringBuilder();
        for (HttpEndpointInfo endpointInfo : httpEndpoints) {
            if (endpointInfo.getError() == null) {
                httpEndpointConfig.append(endpointInfo.toStringConfig());
                continue;
            }
            warnings.add(endpointInfo.getError());
        }
        String prefixes = OdeConfigurationBuilder.buildServiceNameSpaces(httpEndpoints);
        HashMap<String, String> templateSubstitution = new HashMap<String, String>(2);
        templateSubstitution.put("serviceNameSpaces", prefixes);
        templateSubstitution.put("httpEndpoints", httpEndpointConfig.toString());
        try {
            FileUtil.createFileFromTemplate((IProgressMonitor)monitor, (IProject)this.getProject(), (String)HTTP_ENDPOINTS_FILENAME, (InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(HTTP_ENDPOINTS_TEMPLATE), templateSubstitution);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (!warnings.isEmpty()) {
            IStatus[] childs = new IStatus[warnings.size()];
            int i = 0;
            final StringBuilder message = new StringBuilder();
            for (Throwable throwable : warnings) {
                childs[i] = new Status(2, "org.eclipse.swordfish.tooling.ode.ui", throwable.getMessage(), throwable);
                message.append(throwable.getMessage()).append("\n");
                ++i;
            }
            new MultiStatus("org.eclipse.swordfish.tooling.ode.ui", 2, childs, "The ode artifacts builder has reported several warnings", null);
            if (!"always".equals(this.preferenceStore.getString("org.eclipse.swordfish.tooling.ui.ODEArtifactsBuilder.warnings"))) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialogWithToggle.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"ODEArtifactsBuilder has encountered the following error(s)", (String)message.toString(), (String)"Do not show this notification in future", (boolean)false, (IPreferenceStore)OdeArtifactsProjectBuilder.this.preferenceStore, (String)"org.eclipse.swordfish.tooling.ui.ODEArtifactsBuilder.warnings");
                    }
                });
            }
        }
    }

    private String retriveProjectRelativePath(IResource resource) {
        String dir = resource.getProjectRelativePath().toString();
        Assert.isTrue((boolean)dir.startsWith(SRC_FOLDER));
        dir = dir.substring(SRC_FOLDER.length());
        dir = dir.substring(0, dir.lastIndexOf(resource.getName()));
        return dir;
    }

    private void fullBuild(IProgressMonitor monitor) throws CoreException {
        OdeArtifactsHolder artifactsHolder = this.createOdeArtifactsHolder();
        this.performBuild(monitor, artifactsHolder);
    }
}

