/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.tooling.ode.ui.util;

import javax.xml.namespace.QName;
import org.eclipse.swordfish.tooling.ode.ui.util.BpelSupport;

public class HttpEndpointInfo {
    private boolean isProvider;
    private String portName;
    private QName serviceName;
    private String serviceUrl;
    private String wsdlLocation;
    private Throwable error;

    public boolean isProvider() {
        return this.isProvider;
    }

    public void setProvider(boolean isProvider) {
        this.isProvider = isProvider;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public String toStringConfig() {
        if (this.error != null) {
            throw new IllegalStateException();
        }
        StringBuilder ret = new StringBuilder();
        String ws = "                 ";
        ret.append("    <http:endpoint\n" + ws + "endpoint=\"").append(this.portName).append("\"\n");
        ret.append(String.valueOf(ws) + "service=\"").append(String.valueOf(this.serviceName.getPrefix()) + ":" + this.serviceName.getLocalPart()).append("\"\n");
        ret.append(String.valueOf(ws) + "soap=\"true\"\n");
        ret.append(String.valueOf(ws) + "role=\"").append(this.isProvider ? "provider" : "consumer").append("\"\n");
        ret.append(String.valueOf(ws) + "defaultMep=\"http://www.w3.org/2004/08/wsdl/in-out\"\n");
        ret.append(String.valueOf(ws) + "locationURI=\"").append(this.serviceUrl).append("\"\n");
        ret.append(String.valueOf(ws) + "wsdlResource=\"").append(this.wsdlLocation).append("\"/>\n");
        return ret.toString();
    }

    public int hashCode() {
        return (String.valueOf(this.portName) + this.isProvider + this.serviceName + this.serviceUrl + this.wsdlLocation).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return (String.valueOf(this.portName) + this.isProvider + this.serviceName + this.serviceUrl + this.wsdlLocation).equals(obj);
        }
        return false;
    }

    public static HttpEndpointInfo valueOf(BpelSupport.PartnerLinkInfo partnerLinkInfo, String serviceUrl, String wsdlLocation) {
        HttpEndpointInfo httpEndpointInfo = new HttpEndpointInfo();
        httpEndpointInfo.isProvider = partnerLinkInfo.isProvider;
        httpEndpointInfo.portName = partnerLinkInfo.portName;
        httpEndpointInfo.serviceName = partnerLinkInfo.serviceName;
        httpEndpointInfo.serviceUrl = serviceUrl;
        httpEndpointInfo.wsdlLocation = wsdlLocation;
        return httpEndpointInfo;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }
}

