/*******************************************************************************
 * Copyright (c) 2008, 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.wizards;

import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.ui.templates.OptionTemplateSection;
import org.eclipse.pde.ui.templates.TemplateOption;
import org.eclipse.swordfish.tooling.ui.Activator;

/**
 * class PluginContentWizardSection
 * 
 * @author amarkevich
 */
public class PluginContentWizardSection extends OptionTemplateSection {

//	private String pluginId;

	private static final int PAGE_COUNT = 1;
	private WizardPage page;

	/**
	 * {@inheritDoc}
	 */
	public void addPages(Wizard wizard) {
		setPageCount(PAGE_COUNT);

		page = createPage(0, "org.eclipse.swordfish.tooling.doc" + ".create_project");
		page.setTitle("JAX-WS Service Options");
		page.setDescription("Type a service name.");

		wizard.addPage(page);

		markPagesAdded();

		addOption(TemplateConstants.KEY_SERVICE_NAME, "Service name:", "HelloWorld", 0);
	}

	/**
	 * {@inheritDoc}
	 */
	public String getSectionId() {
		return "service";
	}

//	 commented due to https://bugs.eclipse.org/bugs/show_bug.cgi?id=278013
//	protected void initializeFields(IFieldData data) {
//		pluginId = data.getId();
//
//		//initializeOption(KEY_SERVICE_NAME, serviceName);
//	}

	/**
	 * Validate your options here!
	 * 
	 * @param changed - template option
	 */
	public void validateOptions(TemplateOption changed) {
		super.validateOptions(changed);

		if (TemplateConstants.KEY_SERVICE_NAME.equals(changed.getName())) {
			String errorMessage = null;
			IStatus status = JavaConventions.validateClassFileName(
					(String) changed.getValue() + ".class",
					JavaCore.VERSION_1_3,
					JavaCore.VERSION_1_3);
			if (status.getSeverity() == IStatus.ERROR) {
				errorMessage = status.getMessage();
			} else if (status.getSeverity() == IStatus.WARNING) {
				page.setMessage(status.getMessage(), IMessageProvider.WARNING);
			}
			page.setErrorMessage(errorMessage);
			page.setPageComplete(errorMessage == null);
		}
	}

	protected void updateModel(IProgressMonitor monitor) throws CoreException {
	}

	/**
	 * {@inheritDoc}
	 */
	public String getUsedExtensionPoint() {
		return null;
	}

	protected URL getInstallURL() {
		return Activator.getDefault().getBundle().getEntry("/");
	}

	protected String getTemplateDirectory() {
		return "templates"; //$NON-NLS-1$
	}

	protected ResourceBundle getPluginResourceBundle() {
		return Platform.getResourceBundle(Activator.getDefault().getBundle());
	}

	/**
	 * {@inheritDoc}
	 */
	public String[] getNewFiles() {
		return new String[0];
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean isDependentOnParentWizard() {
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	public int getNumberOfWorkUnits() {
		return super.getNumberOfWorkUnits() + PAGE_COUNT;
	}

	/**
	 * {@inheritDoc}
	 */
	public String getStringOption(String name) {
		if (name.equals(TemplateConstants.KEY_SERVICE_ID)) {
			String serviceId = getStringOption(TemplateConstants.KEY_SERVICE_NAME);
			return Character.toLowerCase(serviceId.charAt(0)) + serviceId.substring(1);
		}
		if (name.equals(TemplateConstants.KEY_SERVICE_PACKAGE)) {
			String packageName = (String) super.getValue(KEY_PACKAGE_NAME);
			//System.out.println("packageName1="+packageName);
			// if activator disabled this option missed
			if (packageName == null) {
				//packageName = getFormattedPackageName(pluginId);
				packageName = getFormattedPackageName((String) super.getValue(KEY_PLUGIN_ID));
				//System.out.println("packageName2="+packageName);
			}
			return packageName;
		}
		if (name.equals(TemplateConstants.KEY_SERVICE_INTERFACE)) {
			return getStringOption(TemplateConstants.KEY_SERVICE_NAME);
		}
		if (name.equals(TemplateConstants.KEY_SERVICE_IMPL)) {
			return new StringBuffer()
					.append(getStringOption(TemplateConstants.KEY_SERVICE_NAME))
					.append("Impl")
					.toString();
		}
		if (name.equals(TemplateConstants.KEY_SERVICE_TARGET_NAMESPACE)) {
			return "http://" + getStringOption(TemplateConstants.KEY_SERVICE_PACKAGE);
		}

		if (name.equals(TemplateConstants.KEY_SERVICE_URL)) {
			return "http://localhost:8197/" + getStringOption(TemplateConstants.KEY_SERVICE_NAME) + "/";
		}
		
		if (name.equals(TemplateConstants.KEY_CLIENT_REFS) 
				|| name.equals(TemplateConstants.KEY_CLIENT_SPRING_REFS)) {
			return "";
		}
		return super.getStringOption(name);
	}

	private String getFormattedPackageName(String id) {
		StringBuffer buffer = new StringBuffer();
		for (int i = 0; i < id.length(); i++) {
			char ch = id.charAt(i);
			if (buffer.length() == 0) {
				if (Character.isJavaIdentifierStart(ch)) {
					buffer.append(Character.toLowerCase(ch));
				}
			} else {
				if (Character.isJavaIdentifierPart(ch) || ch == '.') {
					buffer.append(ch);
				}
			}
		}
		return buffer.toString().toLowerCase(Locale.ENGLISH);
	}
}
