/*******************************************************************************
 * Copyright (c) 2008, 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.wizards;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swordfish.registry.tooling.Activator;
import org.eclipse.swordfish.registry.tooling.preferences.PreferenceConstants;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import javax.xml.namespace.QName;

import java.net.URL;
import java.util.Map;

/**
 * Utility class to manage Dialog forms
 * 
 */
public class ServiceRegistryWindow {

	private static final String TITLE = "WSDL files in Swordfish Service Registry";	
	private static final String MESSAGE = "Select one of the available WSDL files to generate a service:";	
	/**
	 * Provides service registry selection dialog.
	 * 
	 * @param shell
	 *            - the shell hosting the dialog
	 * @param extension
	 *            - file extension to filter
	 * @return the String containing full path to file selected
	 */
	public static String selectResourceFromServiceRegistry(Shell shell,
			final String extension) {
       
		ILabelProvider labelProvider = new LabelProvider() {

			public String getText(final Object element) {
				return element.toString();				
			}
		};
		ElementListSelectionDialog dialog = new ElementListSelectionDialog(
				shell, labelProvider);
		List<String> listelements = new ArrayList<String>();
		Map<QName, URL> services = getServices();
		if (services.size() > 0) {
			for (Map.Entry<QName, URL> entry : services.entrySet()) {
				QName key = entry.getKey();
				listelements.add(key.getLocalPart() + " - " + key.getNamespaceURI());
			}
		}
		dialog.setTitle(TITLE);
		dialog.setMessage(MESSAGE);
		dialog.setElements(listelements.toArray());
		dialog.setHelpAvailable(true);
		PlatformUI.getWorkbench().getHelpSystem().setHelp(shell, "org.eclipse.swordfish.tooling.doc" + ".wsdl_sr_look");
		if (dialog.open() == Window.OK) {
			return dialog.getFirstResult().toString().substring(dialog.getFirstResult().toString().indexOf("-") + 2);
		}
		return null;
	}

	private static Map<QName, URL> getServices() {
		Map<QName, URL> services = null;
		try {
			RegistryAccess ra = null;
			String serviceRegistryURL = Activator.getDefault()
					.getPreferenceStore().getString(
							PreferenceConstants.REGISTRY_URL);
			ra = new RegistryAccess(serviceRegistryURL);
			services = ra.getRegisteredServices();
			return services;
		} catch (Exception e) {
			return null;
		}
	}
}
