/*******************************************************************************
 * Copyright (c) 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.wizards.generators;

import java.io.InputStream;

/**
 * Code generator that knows where its result has to be saved
 */
public interface CodeGenerator {
	
	/**
	 * @return the generated code
	 */
	public InputStream generate();
	
	/**
	 * Sets the template provider that can create an input stream for the environment.
	 * @param templateProvider - the new provider
	 */
	public void setTemplateStreamProvider(InputStreamProvider templateProvider);
}
