/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.dependencies.startup;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.osgi.context.DelegatedExecutionOsgiBundleApplicationContext;
import org.springframework.osgi.extender.internal.dependencies.startup.ContextExecutorStateAccessor;
import org.springframework.osgi.extender.internal.dependencies.startup.ContextState;
import org.springframework.osgi.extender.internal.dependencies.startup.ServiceDependency;
import org.springframework.osgi.service.importer.support.AbstractOsgiServiceImportFactoryBean;
import org.springframework.osgi.util.OsgiListenerUtils;
import org.springframework.osgi.util.OsgiStringUtils;

public class DependencyServiceManager {
    private static final Log log = LogFactory.getLog((Class)DependencyServiceManager.class);
    protected final Set dependencies = Collections.synchronizedSet(new LinkedHashSet());
    protected final Set unsatisfiedDependencies = Collections.synchronizedSet(new LinkedHashSet());
    private final ContextExecutorStateAccessor contextStateAccessor;
    private final BundleContext bundleContext;
    private final ServiceListener listener;
    private final DelegatedExecutionOsgiBundleApplicationContext context;
    private final Runnable executeIfDone;

    public DependencyServiceManager(ContextExecutorStateAccessor executor, DelegatedExecutionOsgiBundleApplicationContext context, Runnable executeIfDone) {
        this.contextStateAccessor = executor;
        this.context = context;
        this.bundleContext = context.getBundleContext();
        this.listener = new DependencyServiceListener();
        this.executeIfDone = executeIfDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findServiceDependencies() {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldTCCL = currentThread.getContextClassLoader();
        boolean debug = log.isDebugEnabled();
        try {
            currentThread.setContextClassLoader(this.context.getClassLoader());
            ConfigurableListableBeanFactory beanFactory = this.context.getBeanFactory();
            String[] beans = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, (Class)AbstractOsgiServiceImportFactoryBean.class, (boolean)true, (boolean)false);
            for (int i = 0; i < beans.length; ++i) {
                String beanName = beans[i].startsWith("&") ? beans[i] : "&" + beans[i];
                AbstractOsgiServiceImportFactoryBean reference = (AbstractOsgiServiceImportFactoryBean)beanFactory.getBean(beanName);
                ServiceDependency dependency = new ServiceDependency(this.bundleContext, reference.getUnifiedFilter(), reference.isMandatory());
                String realBean = beanName.substring(1);
                if (debug) {
                    log.debug((Object)("destroying bean " + realBean + " from context " + beanFactory));
                }
                this.dependencies.add(dependency);
                if (dependency.isServicePresent()) continue;
                if (debug) {
                    log.debug((Object)("adding OSGi service dependency for importer " + beanName));
                }
                this.unsatisfiedDependencies.add(dependency);
            }
        }
        finally {
            currentThread.setContextClassLoader(oldTCCL);
        }
        log.info((Object)(this.dependencies.size() + " OSGi service dependencies, " + this.unsatisfiedDependencies.size() + " unsatisfied for " + this.context.getDisplayName()));
    }

    protected boolean isSatisfied() {
        return this.unsatisfiedDependencies.isEmpty();
    }

    public Set getUnsatisfiedDependencies() {
        return this.unsatisfiedDependencies;
    }

    protected void register() {
        String filter = this.createDependencyFilter();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.context.getDisplayName() + " has registered service dependency dependencyDetector with filter: " + filter));
        }
        OsgiListenerUtils.addServiceListener((BundleContext)this.bundleContext, (ServiceListener)this.listener, (String)filter);
    }

    protected String createDependencyFilter() {
        boolean multiple = this.unsatisfiedDependencies.size() > 1;
        StringBuffer sb = new StringBuffer(100 * this.unsatisfiedDependencies.size());
        if (multiple) {
            sb.append("(|");
        }
        Iterator i = this.unsatisfiedDependencies.iterator();
        while (i.hasNext()) {
            sb.append(((ServiceDependency)i.next()).filterAsString);
        }
        if (multiple) {
            sb.append(')');
        }
        return sb.toString();
    }

    protected void deregister() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deregistering service dependency dependencyDetector for " + this.context.getDisplayName()));
        }
        OsgiListenerUtils.removeServiceListener((BundleContext)this.bundleContext, (ServiceListener)this.listener);
    }

    private class DependencyServiceListener
    implements ServiceListener {
        private DependencyServiceListener() {
        }

        public void serviceChanged(ServiceEvent serviceEvent) {
            boolean trace = log.isTraceEnabled();
            boolean debug = log.isDebugEnabled();
            try {
                if (DependencyServiceManager.this.unsatisfiedDependencies.isEmpty()) {
                    if (trace) {
                        log.trace((Object)("handling service event, but no unsatisfied dependencies for " + DependencyServiceManager.this.context.getDisplayName()));
                    }
                    return;
                }
                ServiceReference ref = serviceEvent.getServiceReference();
                if (trace) {
                    log.trace((Object)("handling service event [" + OsgiStringUtils.nullSafeToString((ServiceEvent)serviceEvent) + ":" + OsgiStringUtils.nullSafeToString((ServiceReference)ref) + "] for " + DependencyServiceManager.this.context.getDisplayName()));
                }
                this.updateDependencies(serviceEvent);
                ContextState state = DependencyServiceManager.this.contextStateAccessor.getContextState();
                if (state.isResolved()) {
                    DependencyServiceManager.this.deregister();
                    return;
                }
                if (DependencyServiceManager.this.unsatisfiedDependencies.isEmpty()) {
                    DependencyServiceManager.this.deregister();
                    log.info((Object)("No outstanding OSGi service dependencies, completing initialization for " + DependencyServiceManager.this.context.getDisplayName()));
                    DependencyServiceManager.this.executeIfDone.run();
                }
            }
            catch (Throwable e) {
                log.error((Object)("Exception during dependency processing for " + DependencyServiceManager.this.context.getDisplayName()), e);
            }
        }

        private void updateDependencies(ServiceEvent serviceEvent) {
            boolean trace = log.isTraceEnabled();
            boolean debug = log.isDebugEnabled();
            Iterator i = DependencyServiceManager.this.dependencies.iterator();
            block4: while (i.hasNext()) {
                ServiceDependency dependency = (ServiceDependency)i.next();
                if (dependency.matches(serviceEvent)) {
                    switch (serviceEvent.getType()) {
                        case 1: 
                        case 2: {
                            DependencyServiceManager.this.unsatisfiedDependencies.remove(dependency);
                            if (!debug) continue block4;
                            log.debug((Object)("found service; eliminating " + dependency));
                            continue block4;
                        }
                        case 4: {
                            DependencyServiceManager.this.unsatisfiedDependencies.add(dependency);
                            if (!debug) continue block4;
                            log.debug((Object)("service unregistered; adding " + dependency));
                            continue block4;
                        }
                    }
                    if (!debug) continue;
                    log.debug((Object)("Unknown service event type for: " + dependency));
                    continue;
                }
                if (!trace) continue;
                log.trace((Object)(dependency + " does not match: " + OsgiStringUtils.nullSafeToString((ServiceReference)serviceEvent.getServiceReference())));
            }
        }
    }
}

