/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http;

import javax.jbi.JBIException;
import javax.jbi.component.Bootstrap;
import javax.jbi.component.InstallationContext;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.servicemix.http.HttpConfiguration;

public class HttpBootstrap
implements Bootstrap {
    protected InstallationContext context;
    protected ObjectName mbeanName;
    protected HttpConfiguration configuration;

    public ObjectName getExtensionMBeanName() {
        return this.mbeanName;
    }

    public void init(InstallationContext installContext) throws JBIException {
        try {
            this.context = installContext;
            this.doInit();
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling init", (Throwable)e);
        }
    }

    protected void doInit() throws Exception {
        this.configuration = new HttpConfiguration();
        this.configuration.setRootDir(this.context.getInstallRoot());
        this.configuration.setComponentName(this.context.getComponentName());
        this.configuration.load();
        this.mbeanName = this.context.getContext().getMBeanNames().createCustomComponentMBeanName("bootstrap");
        MBeanServer server = this.context.getContext().getMBeanServer();
        if (server == null) {
            throw new JBIException("null mBeanServer");
        }
        if (server.isRegistered(this.mbeanName)) {
            server.unregisterMBean(this.mbeanName);
        }
        server.registerMBean(this.configuration, this.mbeanName);
    }

    public void cleanUp() throws JBIException {
        try {
            this.doCleanUp();
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling cleanUp", (Throwable)e);
        }
    }

    protected void doCleanUp() throws Exception {
        if (this.mbeanName != null) {
            MBeanServer server = this.context.getContext().getMBeanServer();
            if (server == null) {
                throw new JBIException("null mBeanServer");
            }
            if (server.isRegistered(this.mbeanName)) {
                server.unregisterMBean(this.mbeanName);
            }
        }
    }

    public void onInstall() throws JBIException {
    }

    public void onUninstall() throws JBIException {
    }
}

